/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.ModelAdaptor;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.PostProcessExecutor;
import org.tinymediamanager.core.jmte.TmmModelAdaptor;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;

public class MovieSetPostProcessExecutor
extends PostProcessExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetPostProcessExecutor.class);

    public MovieSetPostProcessExecutor(PostProcess postProcess) {
        super(postProcess);
    }

    @Override
    public void execute() {
        List<MovieSet> selectedMovieSets = MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovieSets();
        for (MovieSet movieSet : selectedMovieSets) {
            LOGGER.info("Executing post process '{}' for movie set '{}'", (Object)this.postProcess.getName(), (Object)movieSet.getTitle());
            String[] command = this.substituteMovieSetTokens(movieSet);
            try {
                this.executeCommand(command, movieSet);
            }
            catch (Exception exception) {}
        }
    }

    private String[] substituteMovieSetTokens(MovieSet movieSet) {
        Engine engine = MovieRenamer.createEngine();
        engine.setModelAdaptor((ModelAdaptor)new TmmModelAdaptor());
        HashMap<String, MovieSet> root = new HashMap<String, MovieSet>();
        root.put("movieSet", movieSet);
        if (this.postProcess.getPath() == null || this.postProcess.getPath().isEmpty()) {
            String transformed = engine.transform(this.postProcess.getCommand(), root);
            return new String[]{transformed};
        }
        String[] splitted = this.postProcess.getCommand().split("\\n");
        for (int i = 0; i < splitted.length; ++i) {
            splitted[i] = engine.transform(splitted[i], root);
        }
        return splitted;
    }
}

