/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.tinymediamanager.jsonrpc.api.AbstractModel;

public final class TexturesModel {

    public static interface TextureFields {
        public static final String URL = "url";
        public static final String CACHEDURL = "cachedurl";
        public static final String LASTHASHCHECK = "lasthashcheck";
        public static final String IMAGEHASH = "imagehash";
        public static final String SIZES = "sizes";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("url", "cachedurl", "lasthashcheck", "imagehash", "sizes"));
    }

    public static class TextureDetail
    extends AbstractModel {
        public static final String API_TYPE = "Textures.Details.Texture";
        public static final String CACHEDURL = "cachedurl";
        public static final String IMAGEHASH = "imagehash";
        public static final String LASTHASHCHECK = "lasthashcheck";
        public static final String SIZES = "sizes";
        public static final String TEXTUREID = "textureid";
        public static final String URL = "url";
        public final String cachedurl;
        public final String imagehash;
        public final String lasthashcheck;
        public final List<SizeDetail> sizes;
        public final Integer textureid;
        public final String url;

        public TextureDetail(String string, String string2, String string3, List<SizeDetail> list, Integer n, String string4) {
            this.cachedurl = string;
            this.imagehash = string2;
            this.lasthashcheck = string3;
            this.sizes = list;
            this.textureid = n;
            this.url = string4;
        }

        public TextureDetail(JsonNode jsonNode) {
            this.cachedurl = TextureDetail.parseString(jsonNode, CACHEDURL);
            this.imagehash = TextureDetail.parseString(jsonNode, IMAGEHASH);
            this.lasthashcheck = TextureDetail.parseString(jsonNode, LASTHASHCHECK);
            this.sizes = SizeDetail.getTexturesModelSizeDetailList(jsonNode, SIZES);
            this.textureid = TextureDetail.parseInt(jsonNode, TEXTUREID);
            this.url = TextureDetail.parseString(jsonNode, URL);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(CACHEDURL, this.cachedurl);
            objectNode.put(IMAGEHASH, this.imagehash);
            objectNode.put(LASTHASHCHECK, this.lasthashcheck);
            ArrayNode arrayNode = OM.createArrayNode();
            for (SizeDetail sizeDetail : this.sizes) {
                arrayNode.add(sizeDetail.toJsonNode());
            }
            objectNode.put(SIZES, (JsonNode)arrayNode);
            objectNode.put(TEXTUREID, this.textureid);
            objectNode.put(URL, this.url);
            return objectNode;
        }

        static List<TextureDetail> getTexturesModelTextureDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<TextureDetail> arrayList = new ArrayList<TextureDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new TextureDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<TextureDetail>(0);
        }
    }

    public static class SizeDetail
    extends AbstractModel {
        public static final String API_TYPE = "Textures.Details.Size";
        public static final String HEIGHT = "height";
        public static final String LASTUSED = "lastused";
        public static final String SIZE = "size";
        public static final String USECOUNT = "usecount";
        public static final String WIDTH = "width";
        public final Integer height;
        public final String lastused;
        public final Integer size;
        public final Integer usecount;
        public final Integer width;

        public SizeDetail(Integer n, String string, Integer n2, Integer n3, Integer n4) {
            this.height = n;
            this.lastused = string;
            this.size = n2;
            this.usecount = n3;
            this.width = n4;
        }

        public SizeDetail(JsonNode jsonNode) {
            this.height = SizeDetail.parseInt(jsonNode, HEIGHT);
            this.lastused = SizeDetail.parseString(jsonNode, LASTUSED);
            this.size = SizeDetail.parseInt(jsonNode, SIZE);
            this.usecount = SizeDetail.parseInt(jsonNode, USECOUNT);
            this.width = SizeDetail.parseInt(jsonNode, WIDTH);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(HEIGHT, this.height);
            objectNode.put(LASTUSED, this.lastused);
            objectNode.put(SIZE, this.size);
            objectNode.put(USECOUNT, this.usecount);
            objectNode.put(WIDTH, this.width);
            return objectNode;
        }

        static List<SizeDetail> getTexturesModelSizeDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<SizeDetail> arrayList = new ArrayList<SizeDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new SizeDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<SizeDetail>(0);
        }
    }
}

