/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.clipinf;

import jakarta.xml.bind.annotation.XmlType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.library.bluray.clipinf.ProgramSequence;

@XmlType(propOrder={"reserved", "number", "programSequence"})
public class ProgramInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProgramInfo.class);
    private byte reserved;
    private byte number;
    private ProgramSequence[] programSequence;

    public int size() {
        return 6 + (this.number > 0 ? this.programSequence[0].size() * this.number : 0);
    }

    public byte getReserved() {
        return this.reserved;
    }

    public void setReserved(byte by) {
        this.reserved = by;
    }

    public byte getNumber() {
        return this.number;
    }

    public void setNumber(byte by) {
        this.number = by;
    }

    public ProgramSequence[] getProgramSequence() {
        return this.programSequence;
    }

    public void setProgramSequence(ProgramSequence[] programSequenceArray) {
        this.programSequence = programSequenceArray;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        LOGGER.trace("ProgramInfo length=" + n);
        this.reserved = dataInputStream.readByte();
        LOGGER.trace("ProgramInfo reserved=" + this.reserved);
        this.number = dataInputStream.readByte();
        LOGGER.trace("ProgramInfo number=" + this.number);
        this.programSequence = new ProgramSequence[this.number];
        for (int i = 0; i < this.number; ++i) {
            this.programSequence[i] = new ProgramSequence();
            this.programSequence[i].readObject(dataInputStream);
        }
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.size() - 4);
        dataOutputStream.writeByte(this.getReserved());
        dataOutputStream.writeByte(this.getNumber());
        for (int i = 0; i < this.number; ++i) {
            this.programSequence[i].writeObject(dataOutputStream);
        }
    }
}

