/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.tinymediamanager.library.bluray.playlist.HexStringIntegerAdapter;
import org.tinymediamanager.library.bluray.playlist.StreamCodingType;
import org.tinymediamanager.library.bluray.playlist.StringIOHelper;

public class StreamAttribute {
    private Integer streamCodingType;
    private VideoFormat videoFormat;
    private FrameRate frameRate;
    private AudioPresentationType audioPresentationType;
    private SamplingFrequency samplingFrequency;
    private String audioLanguageCode;
    private String pgLanguageCode;
    private String igLanguageCode;
    private Integer characterCode;
    private String textSTLanguageCode;
    private Integer dynamicRangeType;
    private Integer colorSpace;
    private Integer criUsageFlag;

    public void readObject(DataInputStream dataInputStream) throws IOException {
        dataInputStream.skipBytes(1);
        int n = dataInputStream.readUnsignedByte();
        this.setStreamCodingType(n);
        StreamCodingType streamCodingType = StreamCodingType.getType(n);
        if (streamCodingType == null) {
            throw new IOException("Error in getting StreamCodingType " + Integer.toHexString(n));
        }
        if (streamCodingType.isVideoStream()) {
            int n2;
            int n3 = dataInputStream.readUnsignedByte();
            int n4 = n3 >> 4;
            VideoFormat[] videoFormatArray = VideoFormat.values();
            for (n2 = 0; n2 < videoFormatArray.length; ++n2) {
                if (videoFormatArray[n2].ordinal() != n4) continue;
                this.setVideoFormat(videoFormatArray[n2]);
                break;
            }
            n2 = n3 & 0xF;
            FrameRate[] frameRateArray = FrameRate.values();
            for (int i = 0; i < frameRateArray.length; ++i) {
                if (frameRateArray[i].ordinal() != n2) continue;
                this.setFrameRate(frameRateArray[i]);
                break;
            }
            n3 = dataInputStream.readUnsignedByte();
            this.setDynamicRangeType(n3 >> 4);
            this.setColorSpace(n3 & 0xF);
            n3 = dataInputStream.readUnsignedByte();
            this.setCriUsageFlag(n3);
            dataInputStream.skipBytes(1);
        } else if (streamCodingType.isAudioStream()) {
            int n5;
            int n6 = dataInputStream.readUnsignedByte();
            int n7 = n6 >> 4;
            AudioPresentationType[] audioPresentationTypeArray = AudioPresentationType.values();
            for (n5 = 0; n5 < audioPresentationTypeArray.length; ++n5) {
                if (audioPresentationTypeArray[n5].ordinal() != n7) continue;
                this.setAudioPresentationType(audioPresentationTypeArray[n5]);
                break;
            }
            n5 = n6 & 0xF;
            SamplingFrequency[] samplingFrequencyArray = SamplingFrequency.values();
            for (int i = 0; i < samplingFrequencyArray.length; ++i) {
                if (samplingFrequencyArray[i].ordinal() != n5) continue;
                this.setSamplingFrequency(samplingFrequencyArray[i]);
                break;
            }
            this.setAudioLanguageCode(StringIOHelper.readISO646String(dataInputStream, 3));
        } else if (streamCodingType.isPGStream()) {
            this.setPGLanguageCode(StringIOHelper.readISO646String(dataInputStream, 3));
            dataInputStream.skipBytes(1);
        } else if (streamCodingType.isIGStream()) {
            this.setIGLanguageCode(StringIOHelper.readISO646String(dataInputStream, 3));
            dataInputStream.skipBytes(1);
        } else if (streamCodingType.isTextSubTitleStream()) {
            this.setCharacterCode(dataInputStream.readUnsignedByte());
            this.setTextSTLanguageCode(StringIOHelper.readISO646String(dataInputStream, 3));
        } else {
            throw new IOException("Error in reading StreamAttribute, type = " + streamCodingType);
        }
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        Integer n = this.getStreamCodingType();
        StreamCodingType streamCodingType = StreamCodingType.getType(n);
        if (streamCodingType == null) {
            throw new IOException("Error in getting StreamCodingType " + n);
        }
        if (streamCodingType.isVideoStream()) {
            dataOutputStream.write(5);
            dataOutputStream.writeByte(this.getStreamCodingType());
            int n2 = this.getVideoFormat().ordinal() << 4;
            dataOutputStream.writeByte(n2 |= this.getFrameRate().ordinal());
            dataOutputStream.writeByte(this.getDynamicRangeType() << 4 | this.getColorSpace());
            dataOutputStream.writeByte(this.getCriUsageFlag());
            dataOutputStream.write(new byte[1]);
        } else if (streamCodingType.isAudioStream()) {
            dataOutputStream.write(5);
            dataOutputStream.writeByte(this.getStreamCodingType());
            int n3 = this.getAudioPresentationType().ordinal() << 4;
            dataOutputStream.writeByte(n3 |= this.getSamplingFrequency().ordinal());
            dataOutputStream.write(StringIOHelper.getISO646Bytes(this.getAudioLanguageCode()));
        } else if (streamCodingType.isPGStream()) {
            dataOutputStream.write(5);
            dataOutputStream.writeByte(this.getStreamCodingType());
            dataOutputStream.write(StringIOHelper.getISO646Bytes(this.getPGLanguageCode()));
            dataOutputStream.writeByte(0);
        } else if (streamCodingType.isIGStream()) {
            dataOutputStream.write(5);
            dataOutputStream.writeByte(this.getStreamCodingType());
            dataOutputStream.write(StringIOHelper.getISO646Bytes(this.getIGLanguageCode()));
            dataOutputStream.writeByte(0);
        } else if (streamCodingType.isTextSubTitleStream()) {
            dataOutputStream.write(5);
            dataOutputStream.writeByte(this.getStreamCodingType());
            dataOutputStream.writeByte(this.getCharacterCode());
            dataOutputStream.write(StringIOHelper.getISO646Bytes(this.getTextSTLanguageCode()));
        } else {
            dataOutputStream.write(1);
            dataOutputStream.writeByte(this.getStreamCodingType());
        }
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=HexStringIntegerAdapter.class)
    public Integer getStreamCodingType() {
        return this.streamCodingType;
    }

    public void setStreamCodingType(Integer n) {
        this.streamCodingType = n;
    }

    public VideoFormat getVideoFormat() {
        return this.videoFormat;
    }

    public void setVideoFormat(VideoFormat videoFormat) {
        this.videoFormat = videoFormat;
    }

    public FrameRate getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(FrameRate frameRate) {
        this.frameRate = frameRate;
    }

    public Integer getDynamicRangeType() {
        return this.dynamicRangeType;
    }

    public void setDynamicRangeType(Integer n) {
        this.dynamicRangeType = n;
    }

    public Integer getColorSpace() {
        return this.colorSpace;
    }

    public void setColorSpace(Integer n) {
        this.colorSpace = n;
    }

    public Integer getCriUsageFlag() {
        return this.criUsageFlag;
    }

    public void setCriUsageFlag(Integer n) {
        this.criUsageFlag = n;
    }

    public AudioPresentationType getAudioPresentationType() {
        return this.audioPresentationType;
    }

    public void setAudioPresentationType(AudioPresentationType audioPresentationType) {
        this.audioPresentationType = audioPresentationType;
    }

    public SamplingFrequency getSamplingFrequency() {
        return this.samplingFrequency;
    }

    public void setSamplingFrequency(SamplingFrequency samplingFrequency) {
        this.samplingFrequency = samplingFrequency;
    }

    public String getAudioLanguageCode() {
        return this.audioLanguageCode;
    }

    public void setAudioLanguageCode(String string) {
        this.audioLanguageCode = string;
    }

    public String getPGLanguageCode() {
        return this.pgLanguageCode;
    }

    public void setPGLanguageCode(String string) {
        this.pgLanguageCode = string;
    }

    public String getIGLanguageCode() {
        return this.igLanguageCode;
    }

    public void setIGLanguageCode(String string) {
        this.igLanguageCode = string;
    }

    @XmlJavaTypeAdapter(value=HexStringIntegerAdapter.class)
    public Integer getCharacterCode() {
        return this.characterCode;
    }

    public void setCharacterCode(Integer n) {
        this.characterCode = n;
    }

    public String getTextSTLanguageCode() {
        return this.textSTLanguageCode;
    }

    public void setTextSTLanguageCode(String string) {
        this.textSTLanguageCode = string;
    }

    public static enum SamplingFrequency {
        RESERVED_0,
        KHz_48,
        RESERVED_2,
        RESERVED_3,
        KHz_96,
        KHz_192,
        RESERVED_6,
        RESERVED_7,
        RESERVED_8,
        RESERVED_9,
        RESERVED_10,
        RESERVED_11,
        KHz_48_AND_192,
        RESERVED_13,
        KHz_48_AND_96,
        RESERVED_15;


        public byte getEncoding() {
            return (byte)this.ordinal();
        }
    }

    public static enum AudioPresentationType {
        RESERVED_0,
        SINGLE_MONO_CHANNEL,
        RESERVED_2,
        STEREO,
        RESERVED_4,
        RESERVED_5,
        MULTI_CHANNEL,
        RESERVED_7,
        RESERVED_8,
        RESERVED_9,
        RESERVED_10,
        RESERVED_11,
        STEREO_AND_MULTI_CHANNEL,
        RESERVED_13,
        RESERVED_14,
        RESERVED_15;


        public byte getEncoding() {
            return (byte)this.ordinal();
        }
    }

    public static enum FrameRate {
        RESERVED,
        Hz_24000_1001,
        Hz_24,
        Hz_25,
        Hz_30000_1001,
        RESERVED_5,
        Hz_50,
        Hz_60000_1001;


        public byte getEncoding() {
            return (byte)this.ordinal();
        }
    }

    public static enum VideoFormat {
        RESERVED,
        VIDEO_480i,
        VIDEO_576i,
        VIDEO_480p,
        VIDEO_1080i,
        VIDEO_720p,
        VIDEO_1080p,
        VIDEO_576p,
        VIDEO_2160p;


        public byte getEncoding() {
            return (byte)this.ordinal();
        }
    }
}

