/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.fernsehserien;

import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.InMemoryCachedUrl;
import org.tinymediamanager.scraper.http.OnDiskCachedUrl;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.util.CacheMap;
import org.tinymediamanager.scraper.util.DateUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class FernsehserienParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FernsehserienParser.class);
    private static final Pattern IMDB_ID_PATTERN = Pattern.compile("imdb\\.com/title/(tt[0-9]{6,})");
    private static final Pattern TVDB_ID_PATTERN = Pattern.compile("thetvdb\\.com/series/([0-9]+)");
    private static final Pattern TVDB_ID_PATTERN2 = Pattern.compile("thetvdb\\.com/.*?id=([0-9]+)");
    private static final Pattern TVMAZE_ID_PATTERN = Pattern.compile("tvmaze\\.com/shows/([0-9]+)");
    private static final CacheMap<String, List<MediaMetadata>> EPISODE_LIST_CACHE_MAP = new CacheMap(60L, 10L);
    private final IMediaProvider mediaProvider;

    FernsehserienParser(IMediaProvider mediaProvider, ExecutorService executor) {
        this.mediaProvider = mediaProvider;
    }

    protected SortedSet<MediaSearchResult> search(MediaSearchAndScrapeOptions options) throws ScrapeException {
        TreeSet<MediaSearchResult> results;
        block14: {
            LOGGER.debug("search(): {}", (Object)options);
            results = new TreeSet<MediaSearchResult>();
            String searchTerm = options.getSearchQuery();
            if (StringUtils.isEmpty((CharSequence)searchTerm)) {
                return results;
            }
            searchTerm = MetadataUtil.removeNonSearchCharacters(searchTerm);
            LOGGER.debug("========= BEGIN Fernsehserien Scraper Search for: {}", (Object)searchTerm);
            try {
                Document doc = null;
                InMemoryCachedUrl url = new InMemoryCachedUrl(this.mediaProvider.getApiKey() + "suche/" + URLEncoder.encode(searchTerm, StandardCharsets.UTF_8));
                InputStream is = ((Url)url).getInputStream();
                doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
                doc.setBaseUri(this.mediaProvider.getApiKey());
                Element ul = doc.getElementsByClass("suchergebnisse").first();
                if (ul != null) {
                    Elements li = ul.getElementsByTag("li");
                    block6: for (Element result : li) {
                        switch (options.getMediaType()) {
                            case MOVIE: {
                                if (result.attr("class").contains("film")) break;
                                continue block6;
                            }
                            case TV_SHOW: {
                                if (result.attr("class").contains("sendung")) break;
                                continue block6;
                            }
                        }
                        MediaSearchResult sr = new MediaSearchResult("fernsehserien", options.getMediaType());
                        Element a = result.getElementsByTag("a").first();
                        if (a != null) {
                            String title = a.attr("title");
                            String id = a.attr("href").substring(1);
                            sr.setId(id);
                            sr.setTitle(title);
                        }
                        int year = 0;
                        Elements dds = result.getElementsByTag("dd");
                        for (Element el : dds) {
                            String y = el.ownText();
                            year = MetadataUtil.parseInt(y = StrgUtils.substr(y, ".*(\\d{4}).*"), 0);
                            if (year <= 0) continue;
                            break;
                        }
                        sr.setYear(year);
                        Element div = result.getElementsByTag("div").first();
                        if (div != null) {
                            String posterUrl = div.attr("data-src");
                            sr.setPosterUrl(posterUrl);
                        }
                        sr.calculateScore(options);
                        results.add(sr);
                    }
                    break block14;
                }
                Element ogurl = doc.getElementsByAttributeValue("property", "og:url").first();
                if (ogurl != null) {
                    String id = ogurl.attr("content");
                    if (!(id = id.replace(this.mediaProvider.getApiKey(), "")).startsWith("suche")) {
                        options.setId("fernsehserien", id);
                        MediaMetadata md = this.getMetadata(options);
                        MediaSearchResult sr = md.toSearchResult(options.getMediaType());
                        sr.setScore(1.0f);
                        results.add(sr);
                    }
                    break block14;
                }
                throw new MissingIdException(new String[]{"fernsehserien"});
            }
            catch (Exception e) {
                LOGGER.debug("tried to fetch search response", (Throwable)e);
                throw new ScrapeException(e);
            }
        }
        LOGGER.debug("Found {} results.", (Object)results.size());
        return results;
    }

    MediaMetadata getEpisodeMetadata(TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException {
        MediaMetadata md;
        block21: {
            OnDiskCachedUrl url;
            LOGGER.debug("getMetadata(): {}", (Object)options);
            md = new MediaMetadata("fernsehserien");
            md.setScrapeOptions(options);
            int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
            int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
            String episodeId = options.getIdAsString("fernsehserien");
            if (!MediaIdUtil.isValidImdbId(episodeId)) {
                episodeId = "";
            }
            List<MediaMetadata> episodes = this.getEpisodeList(options.createTvShowSearchAndScrapeOptions());
            MediaMetadata wantedEpisode = null;
            if (StringUtils.isNotBlank((CharSequence)episodeId)) {
                for (MediaMetadata episode : episodes) {
                    if (!episodeId.equals(episode.getId("fernsehserien"))) continue;
                    wantedEpisode = episode;
                    break;
                }
            }
            if (wantedEpisode == null) {
                for (MediaMetadata episode : episodes) {
                    MediaEpisodeNumber episodeNumber = episode.getEpisodeNumber(MediaEpisodeGroup.EpisodeGroupType.AIRED);
                    if (episodeNumber == null || episodeNumber.season() != seasonNr || episodeNumber.episode() != episodeNr) continue;
                    wantedEpisode = episode;
                    break;
                }
            }
            if (wantedEpisode == null && StringUtils.isBlank((CharSequence)episodeId)) {
                LOGGER.debug("episode not found");
                throw new NothingFoundException();
            }
            md.mergeFrom(wantedEpisode);
            md.removeId("fs-sid");
            String SeasonID = wantedEpisode.getIdAsString("fs-sid");
            String showUrl = (String)options.getTvShowIds().get("fernsehserien");
            String wantedEpisodeId = wantedEpisode.getIdAsString("fernsehserien");
            try {
                url = new OnDiskCachedUrl(this.mediaProvider.getApiKey() + showUrl + "/episodenguide/staffel-" + seasonNr + "/" + SeasonID, 1, TimeUnit.DAYS);
            }
            catch (Exception e) {
                LOGGER.debug("problem scraping: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
            try (InputStream is = url.getInputStream();){
                Document doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
                if (doc == null) break block21;
                for (Element episode : doc.getElementsByAttributeValue("itemprop", "episode")) {
                    Element img;
                    String entryId;
                    Element button = episode.getElementsByTag("button").first();
                    if (button == null || !(entryId = button.attr("data-episode-id")).equals(wantedEpisodeId)) continue;
                    Element fig = null;
                    Element plotEl = episode.getElementsByAttributeValue("itemprop", "description").first();
                    if (plotEl == null) {
                        plotEl = episode.getElementsByClass("episode-output-inhalt").first();
                    }
                    if (plotEl != null) {
                        fig = plotEl.getElementsByTag("figure").first();
                        plotEl.select("figure").remove();
                        plotEl.select("br").before("\n");
                        plotEl.select("p").before("\n\n");
                        plotEl.select("div").before("\n\n");
                        md.setPlot(plotEl.wholeText().replace("  ", " ").strip());
                    }
                    if (fig != null && (img = fig.getElementsByTag("img").first()) != null) {
                        MediaArtwork art = new MediaArtwork("fernsehserien", MediaArtwork.MediaArtworkType.POSTER);
                        art.setOriginalUrl(img.attr("src"));
                    }
                    break;
                }
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.debug("problem scraping: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
        }
        return md;
    }

    MediaMetadata getMetadata(MediaSearchAndScrapeOptions options) throws ScrapeException {
        MediaMetadata md;
        block42: {
            OnDiskCachedUrl url;
            LOGGER.debug("getMetadata(): {}", (Object)options);
            md = new MediaMetadata("fernsehserien");
            md.setScrapeOptions(options);
            md.addEpisodeGroup(MediaEpisodeGroup.DEFAULT_AIRED);
            String id = "";
            if (options.getSearchResult() != null) {
                id = options.getSearchResult().getIdAsString("fernsehserien");
            }
            if (StringUtils.isBlank((CharSequence)id)) {
                id = options.getIdAsString("fernsehserien");
            }
            if (StringUtils.isBlank((CharSequence)id)) {
                LOGGER.debug("not possible to scrape from Fernsehserien.de - no id found");
                throw new MissingIdException(new String[]{"fernsehserien"});
            }
            md.setId("fernsehserien", id);
            try {
                url = new OnDiskCachedUrl(this.mediaProvider.getApiKey() + id, 1, TimeUnit.DAYS);
            }
            catch (Exception e) {
                LOGGER.debug("problem scraping: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
            try (InputStream is = url.getInputStream();){
                Element eg;
                Element genres;
                Element img;
                Element lang;
                Document doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
                if (doc == null) break block42;
                Element title = doc.head().getElementsByAttributeValue("name", "title").first();
                String[] ty = null;
                if (title != null) {
                    ty = ParserUtils.detectCleanTitleAndYear(title.attr("content"), null);
                } else {
                    title = doc.getElementsByAttributeValue("property", "og:title").first();
                }
                if (title != null) {
                    ty = ParserUtils.detectCleanTitleAndYear(title.attr("content"), null);
                }
                md.setTitle(ty[0]);
                if (!ty[1].isEmpty()) {
                    md.setYear(MetadataUtil.parseInt(ty[1], 0));
                }
                if ((lang = doc.getElementsByAttributeValue("itemprop", "inLanguage").first()) != null) {
                    md.setOriginalLanguage(lang.attr("content"));
                }
                Elements countries = doc.getElementsByAttributeValue("itemprop", "countryOfOrigin");
                for (Element country : countries) {
                    md.addCountry(country.attr("title"));
                }
                Element otitle = doc.getElementsByAttributeValue("itemprop", "alternateName").first();
                if (otitle != null) {
                    md.setOriginalTitle(otitle.text());
                }
                Element fig = null;
                Element plotEl = doc.getElementsByAttributeValue("itemprop", "description").first();
                if (plotEl == null) {
                    plotEl = doc.getElementsByClass("episode-output-inhalt").first();
                }
                if (plotEl != null) {
                    fig = plotEl.getElementsByTag("figure").first();
                    plotEl.select("figure").remove();
                    plotEl.select("br").before("\n");
                    plotEl.select("p").before("\n\n");
                    plotEl.select("div").before("\n\n");
                    md.setPlot(plotEl.wholeText().replace("  ", " ").strip());
                }
                if (fig != null && (img = fig.getElementsByTag("img").first()) != null) {
                    MediaArtwork art = new MediaArtwork("fernsehserien", MediaArtwork.MediaArtworkType.POSTER);
                    art.setOriginalUrl(img.attr("src"));
                }
                if ((genres = doc.getElementsByClass("genrepillen").first()) != null) {
                    for (Iterator li : genres.getElementsByTag("li")) {
                        md.addGenre(MediaGenres.getGenre(li.text()));
                    }
                }
                Elements links = doc.getElementsByClass("sendung-spielfilm-person-links-optional");
                for (Object link : links) {
                    String href = link.getElementsByTag("a").attr("href");
                    Matcher matcher = IMDB_ID_PATTERN.matcher(href);
                    if (matcher.find() && matcher.group(1) != null) {
                        md.setId("imdb", matcher.group(1));
                    }
                    if ((matcher = TVDB_ID_PATTERN.matcher(href)).find() && matcher.group(1) != null) {
                        md.setId("tvdb", matcher.group(1));
                    }
                    if ((matcher = TVDB_ID_PATTERN2.matcher(href)).find() && matcher.group(1) != null) {
                        md.setId("tvdb", matcher.group(1));
                    }
                    if (!(matcher = TVMAZE_ID_PATTERN.matcher(href)).find() || matcher.group(1) == null) continue;
                    md.setId("tvmaze", matcher.group(1));
                }
                HashMap<String, Date> eaAngaben = new HashMap<String, Date>();
                for (Element release : doc.getElementsByTag("ea-angabe")) {
                    String tit = release.getElementsByTag("ea-angabe-titel").text().strip();
                    String dat = release.getElementsByTag("ea-angabe-datum").text().strip();
                    Date d = null;
                    try {
                        dat = dat.replaceFirst(".+ ", "");
                        d = DateUtils.parseDate(dat);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    eaAngaben.put(tit, d);
                }
                if (md.getReleaseDate() == null) {
                    md.setReleaseDate((Date)eaAngaben.get("Deutscher Kinostart"));
                }
                if (md.getReleaseDate() == null) {
                    md.setReleaseDate((Date)eaAngaben.get("Deutsche TV-Premiere"));
                }
                if (md.getReleaseDate() == null) {
                    md.setReleaseDate((Date)eaAngaben.get("Original-Kinostart"));
                }
                if (md.getReleaseDate() == null) {
                    md.setReleaseDate((Date)eaAngaben.get("Original-TV-Premiere"));
                }
                if (md.getReleaseDate() == null) {
                    md.setReleaseDate((Date)eaAngaben.get("Internationaler Kinostart"));
                }
                if (md.getReleaseDate() == null) {
                    md.setReleaseDate((Date)eaAngaben.get("Original-Streaming-Premiere"));
                }
                if (md.getYear() == 0 && md.getReleaseDate() != null) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(md.getReleaseDate());
                    md.setYear(calendar.get(1));
                }
                if ((eg = doc.getElementsByAttributeValue("data-menu-item", "episodenguide").first()) != null) {
                    Elements as = eg.getElementsByAttributeValue("data-event-category", "serienmenu-episoden-staffel");
                    for (Element a : as) {
                        md.addExtraData(a.text().replace(" ", ""), a.attr("href"));
                    }
                }
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.debug("problem scraping: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
        }
        this.parseCastCrewPage(md, options.getMediaType());
        return md;
    }

    private void parseCastCrewPage(MediaMetadata md, MediaType type) throws ScrapeException {
        OnDiskCachedUrl url;
        String id = md.getIdAsString("fernsehserien");
        try {
            String postfix = "/cast-crew";
            if (type == MediaType.MOVIE) {
                postfix = "";
            }
            url = new OnDiskCachedUrl(this.mediaProvider.getApiKey() + id + postfix, 1, TimeUnit.DAYS);
        }
        catch (Exception e) {
            LOGGER.debug("problem scraping: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        try (InputStream is = url.getInputStream();){
            Document doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
            if (doc != null) {
                Person p;
                for (Element cast : doc.getElementsByAttributeValue("itemprop", "actor")) {
                    p = this.parsePersonWoType(cast);
                    if (p == null) continue;
                    p.setType(Person.Type.ACTOR);
                    md.addCastMember(p);
                }
                for (Element cast : doc.getElementsByAttributeValue("itemprop", "director")) {
                    p = this.parsePersonWoType(cast);
                    if (p == null) continue;
                    p.setType(Person.Type.DIRECTOR);
                    p.setRole("Regie");
                    md.addCastMember(p);
                }
                for (Element cast : doc.getElementsByAttributeValue("itemprop", "author")) {
                    p = this.parsePersonWoType(cast);
                    if (p == null) continue;
                    p.setType(Person.Type.WRITER);
                    p.setRole("Drehbuch");
                    md.addCastMember(p);
                }
                for (Element cast : doc.getElementsByAttributeValue("itemprop", "producer")) {
                    p = this.parsePersonWoType(cast);
                    if (p == null) continue;
                    p.setType(Person.Type.PRODUCER);
                    p.setRole("Produzent");
                    md.addCastMember(p);
                }
                for (Element company : doc.getElementsByAttributeValue("itemprop", "productionCompany")) {
                    Element name = company.getElementsByAttributeValue("itemprop", "name").first();
                    if (name == null) continue;
                    md.addProductionCompany(name.text());
                }
            }
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.debug("problem scraping: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
    }

    private Person parsePersonWoType(Element p) {
        try {
            Element role;
            Element profile;
            Person cm = new Person();
            cm.setName(p.getElementsByAttributeValue("itemprop", "name").first().text());
            Element img = p.getElementsByAttributeValue("itemprop", "image").first();
            if (img != null) {
                String imgUrl = img.text();
                cm.setThumbUrl(imgUrl);
            }
            if ((profile = p.getElementsByAttributeValue("itemprop", "url").first()) != null) {
                String href = profile.attr("href");
                cm.setProfileUrl(this.mediaProvider.getApiKey() + href);
            }
            if ((role = p.getElementsByTag("dd").first()) != null) {
                String r = role.ownText();
                r = r.replaceAll("\\(.*", "").trim();
                cm.setRole(r);
            }
            return cm;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected List<MediaMetadata> getEpisodeList(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        List<MediaMetadata> episodes;
        String id;
        block36: {
            OnDiskCachedUrl url;
            LOGGER.debug("getEpisodeList(): {}", (Object)options);
            id = options.getIdAsString("fernsehserien");
            if (StringUtils.isBlank((CharSequence)id)) {
                throw new MissingIdException(new String[]{"fernsehserien"});
            }
            episodes = EPISODE_LIST_CACHE_MAP.get(id + "_" + options.getLanguage().getLanguage());
            if (ListUtils.isNotEmpty(episodes)) {
                return episodes;
            }
            episodes = new ArrayList<MediaMetadata>();
            try {
                url = new OnDiskCachedUrl(this.mediaProvider.getApiKey() + id + "/episodenguide", 1, TimeUnit.DAYS);
            }
            catch (Exception e) {
                LOGGER.debug("problem scraping: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
            try (InputStream is = url.getInputStream();){
                Element href;
                Document doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
                if (doc == null) break block36;
                String seasonID = "";
                Element eg = doc.getElementsByAttributeValue("data-menu-item", "episodenguide").first();
                if (eg != null && (href = eg.getElementsByAttributeValue("data-event-category", "serienmenu-episoden-staffel").first()) != null) {
                    seasonID = href.attr("href").substring(href.attr("href").lastIndexOf(47) + 1);
                }
                block22: for (Element season : doc.getElementsByAttributeValue("itemprop", "containsSeason")) {
                    Elements span = season.getElementsByAttributeValue("itemprop", "seasonNumber");
                    int s = -1;
                    if (!span.isEmpty()) {
                        s = MetadataUtil.parseInt(span.text(), -1);
                    } else {
                        Element name = season.getElementsByAttributeValue("itemprop", "name").first();
                        if (name != null) {
                            String seasonName;
                            switch (seasonName = name.attr("id")) {
                                case "Specials": {
                                    s = 0;
                                    break;
                                }
                                default: {
                                    continue block22;
                                }
                            }
                        }
                    }
                    for (Element episode : season.getElementsByAttributeValue("itemprop", "episode")) {
                        Element name;
                        MediaMetadata ep = new MediaMetadata("fernsehserien");
                        Element button = episode.getElementsByTag("button").first();
                        if (button != null) {
                            ep.setId("fernsehserien", button.attr("data-episode-id"));
                        }
                        ep.setId("fs-sid", seasonID);
                        Element epno = episode.getElementsByAttributeValue("itemprop", "episodeNumber").first();
                        if (epno != null) {
                            int e = MetadataUtil.parseInt(epno.attr("content"), -1);
                            ep.setEpisodeNumber(MediaEpisodeGroup.DEFAULT_AIRED, s, e);
                        }
                        if ((name = episode.getElementsByAttributeValue("itemprop", "name").first()) != null) {
                            ep.setTitle(name.text());
                        }
                        Elements columns = episode.getElementsByAttributeValue("role", "cell");
                        Element otitle = (Element)columns.get(8);
                        ep.setOriginalTitle(otitle.text());
                        ep.setOriginalLanguage(otitle.attr("lang"));
                        Element localRelease = (Element)columns.get(7);
                        String localDate = localRelease.ownText();
                        try {
                            Date d = DateUtils.parseDate(localDate);
                            ep.setReleaseDate(d);
                        }
                        catch (Exception d) {
                            // empty catch block
                        }
                        if (ep.getReleaseDate() == null) {
                            Element origRelease = (Element)columns.get(9);
                            String origDate = origRelease.text();
                            try {
                                Date od = DateUtils.parseDate(origDate);
                                ep.setReleaseDate(od);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        episodes.add(ep);
                    }
                }
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.debug("problem scraping: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
        }
        if (!episodes.isEmpty()) {
            EPISODE_LIST_CACHE_MAP.put(id + "_" + options.getLanguage().getLanguage(), episodes);
        }
        return episodes;
    }

    protected MediaGenres getTmmGenre(String genre) {
        MediaGenres g = null;
        if (StringUtils.isBlank((CharSequence)genre)) {
            return null;
        }
        switch (genre) {
            case "Abenteuer": {
                g = MediaGenres.ADVENTURE;
                break;
            }
            case "Action": {
                g = MediaGenres.ACTION;
                break;
            }
            case "Animation": {
                g = MediaGenres.ANIMATION;
                break;
            }
            case "Anime": {
                g = MediaGenres.ANIME;
                break;
            }
            case "Biographie": {
                g = MediaGenres.ACTION;
                break;
            }
            case "Bumsbuster": {
                g = MediaGenres.EROTIC;
                break;
            }
            case "Comedy": {
                g = MediaGenres.COMEDY;
                break;
            }
            case "Corona-Special": {
                g = MediaGenres.DOCUMENTARY;
                break;
            }
            case "Doku-Drama": {
                g = MediaGenres.DRAMA;
                break;
            }
            case "Doku-Soap": {
                g = MediaGenres.SOAP;
                break;
            }
            case "Dokumentation": {
                g = MediaGenres.DOCUMENTARY;
                break;
            }
            case "Drama": {
                g = MediaGenres.DRAMA;
                break;
            }
            case "Eastern": {
                g = MediaGenres.EASTERN;
                break;
            }
            case "Erotik": {
                g = MediaGenres.EROTIC;
                break;
            }
            case "Familienfilm": {
                g = MediaGenres.FAMILY;
                break;
            }
            case "Fantasy": {
                g = MediaGenres.FANTASY;
                break;
            }
            case "Film noir": {
                g = MediaGenres.FILM_NOIR;
                break;
            }
            case "Gangsterfilm": {
                g = MediaGenres.CRIME;
                break;
            }
            case "Geschichte": {
                g = MediaGenres.HISTORY;
                break;
            }
            case "Geschichtsdrama": {
                g = MediaGenres.HISTORY;
                break;
            }
            case "Gespr\u00e4ch &amp; Diskussion": {
                g = MediaGenres.TALK_SHOW;
                break;
            }
            case "Horror": {
                g = MediaGenres.HORROR;
                break;
            }
            case "Italowestern": {
                g = MediaGenres.WESTERN;
                break;
            }
            case "Kabarett": {
                g = MediaGenres.COMEDY;
                break;
            }
            case "Katastrophenfilm": {
                g = MediaGenres.DISASTER;
                break;
            }
            case "Kinderfilm": {
                g = MediaGenres.FAMILY;
                break;
            }
            case "Kom\u00f6die": {
                g = MediaGenres.COMEDY;
                break;
            }
            case "Kriegsfilm": {
                g = MediaGenres.WAR;
                break;
            }
            case "Krimi": {
                g = MediaGenres.CRIME;
                break;
            }
            case "Kurzfilm": {
                g = MediaGenres.SHORT;
                break;
            }
            case "Liebesfilm": {
                g = MediaGenres.ROMANCE;
                break;
            }
            case "Lifestyle &amp; Mode": {
                g = MediaGenres.REALITY_TV;
                break;
            }
            case "Literaturverfilmung": {
                g = MediaGenres.HISTORY;
                break;
            }
            case "Martial Arts": {
                g = MediaGenres.ACTION;
                break;
            }
            case "Melodram": {
                g = MediaGenres.DRAMA;
                break;
            }
            case "Musical": {
                g = MediaGenres.MUSICAL;
                break;
            }
            case "Musik": {
                g = MediaGenres.MUSIC;
                break;
            }
            case "Mystery": {
                g = MediaGenres.MYSTERY;
                break;
            }
            case "Quiz": {
                g = MediaGenres.GAME_SHOW;
                break;
            }
            case "Ranking-Show": {
                g = MediaGenres.GAME_SHOW;
                break;
            }
            case "Ratgeber": {
                g = MediaGenres.TALK_SHOW;
                break;
            }
            case "Reality": {
                g = MediaGenres.REALITY_TV;
                break;
            }
            case "Road Movie": {
                g = MediaGenres.ROAD_MOVIE;
                break;
            }
            case "Romantic Comedy": {
                g = MediaGenres.ROMANCE;
                break;
            }
            case "Satire": {
                g = MediaGenres.COMEDY;
                break;
            }
            case "Science-Fiction": {
                g = MediaGenres.SCIENCE_FICTION;
                break;
            }
            case "Show": {
                g = MediaGenres.TALK_SHOW;
                break;
            }
            case "Sketch-Comedy": {
                g = MediaGenres.COMEDY;
                break;
            }
            case "Splatter": {
                g = MediaGenres.HORROR;
                break;
            }
            case "Sport": {
                g = MediaGenres.SPORT;
                break;
            }
            case "Stummfilm": {
                g = MediaGenres.SILENT_MOVIE;
                break;
            }
            case "Talk": {
                g = MediaGenres.TALK_SHOW;
                break;
            }
            case "Thriller": {
                g = MediaGenres.THRILLER;
                break;
            }
            case "Tiere": {
                g = MediaGenres.ANIMAL;
                break;
            }
            case "True Crime": {
                g = MediaGenres.CRIME;
                break;
            }
            case "TV Movie": {
                g = MediaGenres.TV_MOVIE;
                break;
            }
            case "Western": {
                g = MediaGenres.WESTERN;
                break;
            }
            case "Zeichentrick": {
                g = MediaGenres.ANIMATION;
                break;
            }
            case "Action &amp; Abenteuer": {
                g = MediaGenres.ACTION;
                break;
            }
            case "Animation &amp; Zeichentrick": {
                g = MediaGenres.ANIMATION;
                break;
            }
            case "Comedyserien": {
                g = MediaGenres.COMEDY;
                break;
            }
            case "Dokumentationen &amp; Sport": {
                g = MediaGenres.DOCUMENTARY;
                break;
            }
            case "Dramen &amp; Soaps": {
                g = MediaGenres.DRAMA;
                break;
            }
            case "Familienserien": {
                g = MediaGenres.FAMILY;
                break;
            }
            case "Kinder &amp; Jugend": {
                g = MediaGenres.FAMILY;
                break;
            }
            case "Science-Fiction &amp; Fantasy": {
                g = MediaGenres.SCIENCE_FICTION;
                break;
            }
            case "Shows, Talk &amp; Musik": {
                g = MediaGenres.TALK_SHOW;
                break;
            }
            default: {
                g = MediaGenres.getGenre(genre);
            }
        }
        return g;
    }
}

