/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.scraper.entities.BaseJsonEntity;
import org.tinymediamanager.scraper.imdb.entities.ImdbCharacter;
import org.tinymediamanager.scraper.imdb.entities.ImdbName;

public class ImdbCast
extends BaseJsonEntity {
    public ImdbName name = null;
    public List<ImdbCharacter> characters = new ArrayList<ImdbCharacter>();

    public Person toTmm(Person.Type type) {
        if (this.name == null || this.name.nameText == null || this.name.nameText.text.isEmpty()) {
            return null;
        }
        Person p = new Person(type);
        p.setId("imdb", this.name.id);
        p.setName(this.name.nameText.text);
        if (this.characters != null) {
            String chars = this.characters.stream().map(character -> character.name).collect(Collectors.joining(" / "));
            p.setRole(chars);
        }
        if (this.name.primaryImage != null) {
            p.setThumbUrl(this.name.primaryImage.url);
        }
        p.setProfileUrl("https://www.imdb.com/name/" + this.name.id);
        return p;
    }
}

