/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.rating;

import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.util.MetadataUtil;

class WikidataRating {
    private static final Logger LOGGER = LoggerFactory.getLogger(WikidataRating.class);

    WikidataRating() {
    }

    List<MediaRating> getRatings(String imdbId) {
        Document doc;
        LOGGER.debug("getRatings(): {}", (Object)imdbId);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ?item ?IMDb_ID ?_review_score ?_review_count ?_score_byLabel ?_score_methodLabel WHERE {");
        sb.append("?item wdt:P345 \"");
        sb.append(imdbId);
        sb.append("\".");
        sb.append("SERVICE wikibase:label { bd:serviceParam wikibase:language \"en\". }");
        sb.append("OPTIONAL { ?item wdt:P345 ?IMDb_ID. }");
        sb.append("OPTIONAL { ?item p:P444 ?review . ?review pq:P447 ?_score_by ; ps:P444 ?_review_score }");
        sb.append("OPTIONAL { ?item p:P444 ?review . ?review pq:P7887 ?_review_count }");
        sb.append("OPTIONAL { ?item p:P444 ?review . ?review pq:P459 ?_score_method }}");
        try {
            Url url = new Url("https://query.wikidata.org/sparql?query=" + URLEncoder.encode(sb.toString(), StandardCharsets.UTF_8));
            doc = Jsoup.parse((InputStream)url.getInputStream(), (String)"UTF-8", (String)"");
        }
        catch (Exception e) {
            LOGGER.debug("could not get ratings - '{}'", (Object)e.getMessage());
            return Collections.emptyList();
        }
        ArrayList<MediaRating> ratings = new ArrayList<MediaRating>();
        Elements elements = doc.getElementsByTag("result");
        for (Element element : elements) {
            MediaRating rating = this.parseRating(element);
            if (rating == null || ratings.contains(rating)) continue;
            ratings.add(rating);
        }
        return ratings;
    }

    private MediaRating parseRating(Element element) {
        MediaRating rating = null;
        try {
            String provider = "";
            String method = "";
            String score = "";
            String votes = "";
            for (Element child : element.children()) {
                switch (child.attr("name")) {
                    case "_score_byLabel": {
                        provider = child.text();
                        break;
                    }
                    case "_score_methodLabel": {
                        method = child.text();
                        break;
                    }
                    case "_review_score": {
                        score = child.text();
                        break;
                    }
                }
            }
            switch (provider) {
                case "Rotten Tomatoes": {
                    if ("Tomatometer score".equals(method) || StringUtils.isBlank((CharSequence)method)) {
                        rating = new MediaRating("tomatometerallcritics");
                        rating.setRating(Float.parseFloat(score.replace("%", "")));
                        rating.setVotes(MetadataUtil.parseInt(votes, 0));
                        rating.setMaxValue(100);
                        break;
                    }
                    if (!"Rotten Tomatoes average rating".equals(method)) break;
                    rating = new MediaRating("tomatometeravgcritics");
                    rating.setRating(Float.parseFloat(score.replace("/10", "")));
                    rating.setVotes(MetadataUtil.parseInt(votes, 0));
                    rating.setMaxValue(10);
                    break;
                }
                case "Metacritic": {
                    rating = new MediaRating("metacritic");
                    rating.setRating(Float.parseFloat(score.replace("/100", "")));
                    rating.setVotes(MetadataUtil.parseInt(votes, 0));
                    rating.setMaxValue(100);
                    break;
                }
                case "Internet Movie Database": {
                    rating = new MediaRating("imdb");
                    rating.setRating(Float.parseFloat(score.replace("/10", "")));
                    rating.setVotes(MetadataUtil.parseInt(votes, 0));
                    rating.setMaxValue(10);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("could not parse rating - '{}'", (Object)e.getMessage());
            return null;
        }
        return rating;
    }
}

