/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.thesportsdb;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.thesportsdb.services.v1.List;
import org.tinymediamanager.scraper.thesportsdb.services.v1.Lookup;
import org.tinymediamanager.scraper.thesportsdb.services.v1.Schedule;
import org.tinymediamanager.scraper.thesportsdb.services.v1.Search;
import org.tinymediamanager.scraper.thesportsdb.services.v2.All;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class TheSportsDbController {
    public static final String API_HOST = "www.thesportsdb.com";
    public static final String API_VERSION = "v1";
    public static final String PATH_API_KEY = "api_key";
    private static final String TSDB_DATE_PATTERN = "yyyy-MM-dd";
    private final String apiUrl;
    private final SimpleDateFormat dateFormat;
    private String apiKey;
    private Retrofit retrofit;

    TheSportsDbController(String apiKey) {
        this.apiKey = apiKey;
        if (apiKey.isEmpty()) {
            this.apiKey = "3";
        }
        this.apiUrl = "https://www.thesportsdb.com/api/v1/";
        this.dateFormat = new SimpleDateFormat(TSDB_DATE_PATTERN, Locale.ENGLISH);
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void swapFreeKey() {
        this.apiKey = this.apiKey.equals("3") ? "123" : "3";
    }

    protected Retrofit getRetrofit() {
        if (this.retrofit == null) {
            this.retrofit = new Retrofit.Builder().baseUrl(this.apiUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGsonBuilder().create())).client(this.okHttpClient()).build();
        }
        return this.retrofit;
    }

    protected synchronized OkHttpClient okHttpClient() {
        OkHttpClient.Builder builder = TmmHttpClient.newBuilderWithForcedCache(1, TimeUnit.DAYS);
        builder.connectTimeout(30L, TimeUnit.SECONDS);
        builder.writeTimeout(30L, TimeUnit.SECONDS);
        builder.readTimeout(30L, TimeUnit.SECONDS);
        builder.addInterceptor(chain -> {
            Request originalRequest = chain.request();
            HttpUrl.Builder urlBuilder = originalRequest.url().newBuilder();
            java.util.List segments = originalRequest.url().pathSegments();
            for (int i = 0; i < segments.size(); ++i) {
                if (!"{api_key}".equalsIgnoreCase((String)segments.get(i))) continue;
                urlBuilder.setPathSegment(i, this.getApiKey());
            }
            Request request = originalRequest.newBuilder().url(urlBuilder.build()).build();
            return chain.proceed(request);
        });
        return builder.build();
    }

    protected GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Integer.class, (json, typeOfT, context) -> json.getAsInt());
        builder.registerTypeAdapter(Date.class, (json, typeOfT, context) -> {
            try {
                return this.dateFormat.parse(json.getAsString());
            }
            catch (ParseException e) {
                return null;
            }
        });
        return builder;
    }

    All AllServiceV2() {
        return (All)this.getRetrofit().create(All.class);
    }

    List listServiceV1() {
        return (List)this.getRetrofit().create(List.class);
    }

    Lookup lookupServiceV1() {
        return (Lookup)this.getRetrofit().create(Lookup.class);
    }

    Schedule ScheduleServiceV1() {
        return (Schedule)this.getRetrofit().create(Schedule.class);
    }

    Search SearchServiceV1() {
        return (Search)this.getRetrofit().create(Search.class);
    }
}

