/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.TrailerSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieTrailerProvider;
import org.tinymediamanager.scraper.tmdb.TmdbMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbTrailerProvider;

public class TmdbMovieTrailerProvider
extends TmdbMetadataProvider
implements IMovieTrailerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbMovieTrailerProvider.class);

    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = super.createMediaProviderInfo();
        info.getConfig().load();
        return info;
    }

    @Override
    protected String getSubId() {
        return "movie_trailer";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public List<MediaTrailer> getTrailers(TrailerSearchAndScrapeOptions options) throws ScrapeException {
        this.initAPI();
        if (options.getMediaType() != MediaType.MOVIE) {
            return Collections.emptyList();
        }
        return new TmdbTrailerProvider(this.api).getTrailers(options);
    }
}

