/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tvmaze.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.bind.DateTypeAdapter;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.tvmaze.entities.AlternateList;
import org.tinymediamanager.scraper.tvmaze.entities.Episode;
import org.tinymediamanager.scraper.tvmaze.entities.SearchResult;
import org.tinymediamanager.scraper.tvmaze.entities.Show;
import org.tinymediamanager.scraper.tvmaze.service.TvMazeService;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class TvMazeController {
    private final Retrofit retrofit;
    private final String apiKey;

    public TvMazeController(String apiKey) {
        this.apiKey = apiKey;
        OkHttpClient.Builder builder = TmmHttpClient.newBuilderWithForcedCache(15, TimeUnit.MINUTES);
        this.retrofit = this.buildRetrofitInstance(builder.build());
    }

    private GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Integer.class, (json, typeOfT, context) -> {
            try {
                return json.getAsInt();
            }
            catch (NumberFormatException e) {
                return 0;
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        return builder;
    }

    private Retrofit buildRetrofitInstance(OkHttpClient client) {
        return new Retrofit.Builder().client(client).baseUrl(this.apiKey).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGsonBuilder().create())).build();
    }

    private TvMazeService getService() {
        return (TvMazeService)this.retrofit.create(TvMazeService.class);
    }

    public List<SearchResult> getTvShowSearchResults(String query) throws IOException {
        return (List)this.getService().showSearch(query).execute().body();
    }

    public Show getMainInformation(int showId) throws IOException {
        return (Show)this.getService().show_main_information(showId).execute().body();
    }

    public Show getByTvdbId(String showId) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("thetvdb", showId);
        return (Show)this.getService().getByProvider(params).execute().body();
    }

    public Show getByImdbId(String showId) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("imdb", showId);
        return (Show)this.getService().getByProvider(params).execute().body();
    }

    public Show getByTvrageId(String showId) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tvrage", showId);
        return (Show)this.getService().getByProvider(params).execute().body();
    }

    public List<AlternateList> getAlternativeLists(int showId) throws IOException {
        return (List)this.getService().alternativeLists(showId).execute().body();
    }

    public List<Episode> getAlternativeEpisodes(int alternateId) throws IOException {
        return (List)this.getService().alternativeEpisodes(alternateId).execute().body();
    }

    public List<Episode> getEpisodes(int showId) throws IOException {
        return (List)this.getService().episodeList(showId).execute().body();
    }

    public List<Episode> getSeasonEpisodes(int seasonId) throws IOException {
        return (List)this.getService().seasonEpisodes(seasonId).execute().body();
    }
}

