/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.upnp;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.fourthline.cling.support.model.DIDLObject;
import org.fourthline.cling.support.model.Person;
import org.fourthline.cling.support.model.PersonWithRole;
import org.fourthline.cling.support.model.Res;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.thirdparty.upnp.MimeTypes;
import org.tinymediamanager.thirdparty.upnp.Upnp;

class Metadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(Metadata.class);

    private Metadata() {
        throw new IllegalAccessError();
    }

    public static org.fourthline.cling.support.model.item.Movie getUpnpMovie(Movie tmmMovie, boolean full) {
        org.fourthline.cling.support.model.item.Movie m = new org.fourthline.cling.support.model.item.Movie();
        try {
            MediaFile poster;
            m.setId(tmmMovie.getDbId().toString());
            m.setParentID("1");
            if (tmmMovie.getYear() > 0) {
                m.addProperty((DIDLObject.Property)new DIDLObject.Property.DC.DATE(Integer.toString(tmmMovie.getYear())));
            }
            m.setTitle(tmmMovie.getTitle());
            List<MediaFile> posters = tmmMovie.getMediaFiles(MediaFileType.POSTER);
            MediaFile mediaFile = poster = posters.isEmpty() ? null : posters.get(0);
            if (poster != null) {
                String rel = tmmMovie.getPathNIO().relativize(poster.getFileAsPath()).toString().replaceAll("\\\\", "/");
                String string = "http://" + Upnp.getInstance().getIpAddress() + ":8009/upnp/movies/" + tmmMovie.getDbId().toString() + "/" + URLEncoder.encode(rel, StandardCharsets.UTF_8);
                Res res = new Res(MimeTypes.getMimeType(poster.getExtension()), Long.valueOf(poster.getFilesize()), string);
                m.addResource(res);
            }
            for (MediaFile mediaFile2 : tmmMovie.getMediaFiles(MediaFileType.VIDEO)) {
                String string = tmmMovie.getPathNIO().relativize(mediaFile2.getFileAsPath()).toString().replaceAll("\\\\", "/");
                String url = "http://" + Upnp.getInstance().getIpAddress() + ":8009/upnp/movies/" + tmmMovie.getDbId().toString() + "/" + URLEncoder.encode(string, StandardCharsets.UTF_8);
                Res r = new Res(MimeTypes.getMimeType(mediaFile2.getExtension()), Long.valueOf(mediaFile2.getFilesize()), url);
                m.addResource(r);
            }
            if (full) {
                ArrayList arrayList;
                m.setDescription(tmmMovie.getPlot());
                m.setLanguage(tmmMovie.getSpokenLanguages());
                m.setRating(String.valueOf(tmmMovie.getRating()));
                ArrayList<String> genres = new ArrayList<String>();
                for (MediaGenres mediaGenres : tmmMovie.getGenres()) {
                    genres.add(mediaGenres.getLocalizedName());
                }
                if (!genres.isEmpty()) {
                    String[] stringArray = genres.toArray(new String[genres.size()]);
                    m.setGenres(stringArray);
                }
                ArrayList<PersonWithRole> arrayList2 = new ArrayList<PersonWithRole>();
                for (org.tinymediamanager.core.entities.Person a : tmmMovie.getActors()) {
                    arrayList2.add(new PersonWithRole(a.getName(), a.getRole()));
                }
                if (!arrayList2.isEmpty()) {
                    PersonWithRole[] personWithRoleArray = arrayList2.toArray(new PersonWithRole[arrayList2.size()]);
                    m.setActors(personWithRoleArray);
                }
                if (!(arrayList = new ArrayList()).isEmpty()) {
                    PersonWithRole[] personWithRoleArray = arrayList.toArray(new PersonWithRole[arrayList.size()]);
                    m.setProducers((Person[])personWithRoleArray);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("UPnP: Error getting movie '{}'", (Object)e.getMessage());
        }
        return m;
    }

    public static org.fourthline.cling.support.model.item.Movie getUpnpTvShowEpisode(TvShow show, TvShowEpisode ep, boolean full) {
        org.fourthline.cling.support.model.item.Movie m = new org.fourthline.cling.support.model.item.Movie();
        try {
            m.setId("2/" + show.getDbId().toString() + "/" + ep.getSeason() + "/" + ep.getEpisode());
            m.setParentID("2/" + show.getDbId().toString() + "/" + ep.getSeason());
            if (ep.getYear() > 0) {
                m.addProperty((DIDLObject.Property)new DIDLObject.Property.DC.DATE(Integer.toString(ep.getYear())));
            }
            m.setTitle("S" + Metadata.lz(ep.getSeason()) + "E" + Metadata.lz(ep.getEpisode()) + " " + ep.getTitle());
            for (MediaFile mediaFile : ep.getMediaFiles(MediaFileType.VIDEO)) {
                String string = show.getPathNIO().relativize(mediaFile.getFileAsPath()).toString().replaceAll("\\\\", "/");
                String url = "http://" + Upnp.getInstance().getIpAddress() + ":8009/upnp/tvshows/" + show.getDbId().toString() + "/" + URLEncoder.encode(string, StandardCharsets.UTF_8);
                Res r = new Res(MimeTypes.getMimeType(mediaFile.getExtension()), Long.valueOf(mediaFile.getFilesize()), url);
                m.addResource(r);
            }
            if (full) {
                m.setDescription(ep.getPlot());
                m.setRating(String.valueOf(ep.getRating()));
                ArrayList<String> genres = new ArrayList<String>();
                for (MediaGenres mediaGenres : show.getGenres()) {
                    genres.add(mediaGenres.getLocalizedName());
                }
                if (!genres.isEmpty()) {
                    String[] stringArray = genres.toArray(new String[genres.size()]);
                    m.setGenres(stringArray);
                }
                ArrayList<PersonWithRole> arrayList = new ArrayList<PersonWithRole>();
                for (org.tinymediamanager.core.entities.Person a : ep.getActors()) {
                    arrayList.add(new PersonWithRole(a.getName(), a.getRole()));
                }
                if (!arrayList.isEmpty()) {
                    PersonWithRole[] personWithRoleArray = arrayList.toArray(new PersonWithRole[arrayList.size()]);
                    m.setActors(personWithRoleArray);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("UPnP: Error getting episode - '{}'", (Object)e.getMessage());
        }
        return m;
    }

    private static String lz(int num) {
        return String.format("%02d", num);
    }
}

