/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatDropShadowBorder;
import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.util.LinkedList;
import java.util.Queue;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;

public class HintManager {
    private static HintManager instance;
    private final Queue<Hint> hints = new LinkedList<Hint>();

    private HintManager() {
    }

    public static HintManager getInstance() {
        if (instance == null) {
            instance = new HintManager();
        }
        return instance;
    }

    public void addHint(String message, Component owner, int position) {
        if (Settings.getInstance().isNewConfig()) {
            this.hints.add(new Hint(message, owner, position));
        }
    }

    public void showHints() {
        this.nextHint();
    }

    private void nextHint() {
        Hint hint = this.hints.poll();
        if (hint != null) {
            this.showHint(hint);
        }
    }

    private void showHint(Hint hint) {
        HintPanel hintPanel = new HintPanel(hint);
        hintPanel.showHint();
    }

    static class Hint {
        private final String message;
        private final Component owner;
        private final int position;

        Hint(String message, Component owner, int position) {
            this.message = message;
            this.owner = owner;
            this.position = position;
        }
    }

    private class HintPanel
    extends JPanel {
        private final Hint hint;
        private JPanel popup;
        private JLabel hintLabel;

        private HintPanel(Hint hint) {
            this.hint = hint;
            this.initComponents();
            this.setOpaque(false);
            this.updateBalloonBorder();
            this.hintLabel.setText("<html><b>" + hint.message + "</b></html>");
            this.addMouseListener(new MouseAdapter(){});
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (UIManager.getLookAndFeel() instanceof FlatLaf) {
                this.setBackground(UIManager.getColor("HintPanel.backgroundColor"));
            } else {
                this.setBackground(FlatUIUtils.nonUIResource((Color)UIManager.getColor("info")));
            }
            if (this.hint != null) {
                this.updateBalloonBorder();
            }
        }

        private void updateBalloonBorder() {
            this.setBorder((Border)((Object)new BalloonBorder(switch (this.hint.position) {
                case 2 -> 4;
                case 1 -> 3;
                case 4 -> 2;
                case 3 -> 1;
                default -> throw new IllegalArgumentException();
            }, FlatUIUtils.getUIColor((String)"PopupMenu.borderColor", (Color)Color.gray))));
        }

        void showHint() {
            JRootPane rootPane = SwingUtilities.getRootPane(this.hint.owner);
            if (rootPane == null) {
                return;
            }
            JLayeredPane layeredPane = rootPane.getLayeredPane();
            this.popup = new JPanel(new BorderLayout()){

                @Override
                public void updateUI() {
                    super.updateUI();
                    EventQueue.invokeLater(() -> {
                        this.validate();
                        this.setSize(this.getPreferredSize());
                    });
                }
            };
            this.popup.setOpaque(false);
            this.popup.add(this);
            Point pt = SwingUtilities.convertPoint(this.hint.owner, 0, 0, layeredPane);
            int x = pt.x;
            int y = pt.y;
            Dimension size = this.popup.getPreferredSize();
            int gap = UIScale.scale((int)6);
            switch (this.hint.position) {
                case 2: {
                    x -= size.width + gap;
                    break;
                }
                case 1: {
                    y -= size.height + gap;
                    break;
                }
                case 4: {
                    x += this.hint.owner.getWidth() + gap;
                    break;
                }
                case 3: {
                    Component component = this.hint.owner;
                    if (component instanceof JTabbedPane) {
                        JTabbedPane tabbedPane = (JTabbedPane)component;
                        Rectangle rect = tabbedPane.getUI().getTabBounds(tabbedPane, 0);
                        y += rect.height + gap;
                        x += rect.width - 2 * gap;
                        break;
                    }
                    if (this.hint.owner instanceof JButton) {
                        y += this.hint.owner.getHeight() - gap;
                        x += this.hint.owner.getWidth() / 2 - (UIScale.scale((int)16) + UIScale.scale((int)8) + gap);
                        break;
                    }
                    y += this.hint.owner.getHeight() + gap;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.popup.setBounds(x, y, size.width, size.height);
            layeredPane.add((Component)this.popup, JLayeredPane.POPUP_LAYER);
        }

        void hideHint() {
            Container parent;
            if (this.popup != null && (parent = this.popup.getParent()) != null) {
                parent.remove(this.popup);
                parent.repaint(this.popup.getX(), this.popup.getY(), this.popup.getWidth(), this.popup.getHeight());
            }
        }

        private void close() {
            this.hideHint();
            HintManager.this.nextHint();
        }

        private void initComponents() {
            this.hintLabel = new JLabel();
            JButton btnClose = new JButton();
            this.setLayout((LayoutManager)new MigLayout("insets dialog,hidemode 3", "[::200,fill]", "[]para[]"));
            this.hintLabel.setText("hint");
            this.add((Component)this.hintLabel, "cell 0 0");
            btnClose.setText(TmmResourceBundle.getString("hintmanager.gotit"));
            btnClose.setFocusable(false);
            btnClose.addActionListener(e -> this.close());
            this.add((Component)btnClose, "cell 0 1,alignx right,growx 0");
        }
    }

    private static class BalloonBorder
    extends FlatEmptyBorder {
        private static final int ARC = 8;
        private static final int ARROW_XY = 16;
        private static final int ARROW_SIZE = 8;
        private static final int SHADOW_SIZE = 3;
        private static final int SHADOW_TOP_SIZE = 1;
        private final int direction;
        private final Color borderColor;
        private final Border shadowBorder;

        public BalloonBorder(int direction, Color borderColor) {
            super(2, 4, 4, 4);
            this.direction = direction;
            this.borderColor = borderColor;
            switch (direction) {
                case 2: {
                    this.left += 8;
                    break;
                }
                case 1: {
                    this.top += 8;
                    break;
                }
                case 4: {
                    this.right += 8;
                    break;
                }
                case 3: {
                    this.bottom += 8;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            int SHADOW_SIZE2 = 5;
            this.shadowBorder = UIManager.getLookAndFeel() instanceof FlatLaf ? new FlatDropShadowBorder(UIManager.getColor("Popup.dropShadowColor"), new Insets(SHADOW_SIZE2, SHADOW_SIZE2, SHADOW_SIZE2, SHADOW_SIZE2), FlatUIUtils.getUIFloat((String)"Popup.dropShadowOpacity", (float)0.5f)) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                FlatUIUtils.setRenderingHints((Graphics)g2);
                g2.translate(x, y);
                int sx = 0;
                int sy = 0;
                int sw = width;
                int sh = height;
                int arrowSize = UIScale.scale((int)8);
                switch (this.direction) {
                    case 2: {
                        sx += arrowSize;
                        sw -= arrowSize;
                        break;
                    }
                    case 1: {
                        sy += arrowSize;
                        sh -= arrowSize;
                        break;
                    }
                    case 4: {
                        sw -= arrowSize;
                        break;
                    }
                    case 3: {
                        sh -= arrowSize;
                    }
                }
                if (this.shadowBorder != null) {
                    this.shadowBorder.paintBorder(c, g2, sx, sy, sw, sh);
                }
                int bx = UIScale.scale((int)3);
                int by = UIScale.scale((int)1);
                int bw = width - UIScale.scale((int)6);
                int bh = height - UIScale.scale((int)4);
                g2.translate(bx, by);
                Shape shape = this.createBalloonShape(bw, bh);
                g2.setColor(c.getBackground());
                g2.fill(shape);
                g2.setColor(this.borderColor);
                g2.setStroke(new BasicStroke(UIScale.scale((float)1.0f)));
                g2.draw(shape);
            }
            finally {
                g2.dispose();
            }
        }

        private Shape createBalloonShape(int width, int height) {
            RoundRectangle2D.Float rect;
            int arc = UIScale.scale((int)8);
            int xy = UIScale.scale((int)16);
            int awh = UIScale.scale((int)8);
            Path2D arrow = switch (this.direction) {
                case 2 -> {
                    rect = new RoundRectangle2D.Float(awh, 0.0f, width - 1 - awh, height - 1, arc, arc);
                    yield FlatUIUtils.createPath((double[])new double[]{awh, xy, 0.0, xy + awh, awh, xy + awh + awh});
                }
                case 1 -> {
                    rect = new RoundRectangle2D.Float(0.0f, awh, width - 1, height - 1 - awh, arc, arc);
                    yield FlatUIUtils.createPath((double[])new double[]{xy, awh, xy + awh, 0.0, xy + awh + awh, awh});
                }
                case 4 -> {
                    rect = new RoundRectangle2D.Float(0.0f, 0.0f, width - 1 - awh, height - 1, arc, arc);
                    int x = width - 1 - awh;
                    yield FlatUIUtils.createPath((double[])new double[]{x, xy, x + awh, xy + awh, x, xy + awh + awh});
                }
                case 3 -> {
                    rect = new RoundRectangle2D.Float(0.0f, 0.0f, width - 1, height - 1 - awh, arc, arc);
                    int y = height - 1 - awh;
                    yield FlatUIUtils.createPath((double[])new double[]{xy, y, xy + awh, y + awh, xy + awh + awh, y});
                }
                default -> throw new IllegalStateException();
            };
            Area area = new Area(rect);
            area.add(new Area(arrow));
            return area;
        }
    }
}

