/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import com.sun.jna.Platform;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BaseMultiResolutionImage;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayer;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.TinyMediaManager;
import org.tinymediamanager.core.ITmmModule;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmModuleManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.thirdparty.MediaInfo;
import org.tinymediamanager.ui.HintManager;
import org.tinymediamanager.ui.ITmmUIModule;
import org.tinymediamanager.ui.LightBox;
import org.tinymediamanager.ui.MainMenuPanel;
import org.tinymediamanager.ui.ShadowLayerUI;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.TmmUIMenuHelper;
import org.tinymediamanager.ui.TmmUIMessageCollector;
import org.tinymediamanager.ui.components.TextFieldPopupMenu;
import org.tinymediamanager.ui.components.tabbedpane.MainTabbedPane;
import org.tinymediamanager.ui.components.toolbar.ToolbarPanel;
import org.tinymediamanager.ui.dialogs.SettingsDialog;
import org.tinymediamanager.ui.images.LogoCircle;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;
import org.tinymediamanager.ui.panels.IModalPopupPanelProvider;
import org.tinymediamanager.ui.panels.ModalPopupPanel;
import org.tinymediamanager.ui.panels.StatusBarPanel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class MainWindow
extends JFrame
implements IModalPopupPanelProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainWindow.class);
    public static final Image LOGOS = MainWindow.createLogos();
    private static MainWindow instance;
    private final Stack<Component> focusedComponents = new Stack();
    private JMenuBar topMenuBar;
    private ToolbarPanel toolbarPanel;
    private JPanel masterPanel;
    private MainMenuPanel menuPanel;
    private JPanel detailPanel;
    private int popupIndex = JLayeredPane.MODAL_LAYER;

    public static synchronized MainWindow getInstance() {
        if (instance == null) {
            new MainWindow("tinyMediaManager");
        }
        return instance;
    }

    private MainWindow(String name) {
        super(name);
        this.setName("mainWindow");
        this.setMinimumSize(new Dimension(1050, 700));
        instance = this;
        this.initialize();
    }

    private static Image createLogos() {
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(new LogoCircle(48).getImage());
        images.add(new LogoCircle(64).getImage());
        images.add(new LogoCircle(96).getImage());
        images.add(new LogoCircle(128).getImage());
        images.add(new LogoCircle(256).getImage());
        images.add(new LogoCircle(512).getImage());
        images.add(new LogoCircle(1024).getImage());
        return new BaseMultiResolutionImage(5, images.toArray(new Image[0]));
    }

    private void initialize() {
        this.setIconImage(LOGOS);
        this.setBounds(5, 5, 1100, 720);
        this.setDefaultCloseOperation(0);
        if (SystemUtils.IS_OS_MAC) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            this.topMenuBar = new JMenuBar();
            this.setJMenuBar(this.topMenuBar);
        }
        this.toolbarPanel = new ToolbarPanel();
        this.getContentPane().add((Component)this.toolbarPanel, "North");
        JPanel rootPanel = new JPanel();
        Color color = UIManager.getColor("Panel.tmmAlternateBackground");
        if (color != null) {
            rootPanel.setBackground(color);
        }
        rootPanel.setLayout((LayoutManager)new MigLayout("insets 0", "[]0lp[900lp:n,grow]", "[300lp:400lp,grow,shrink 0]"));
        JLayer<JComponent> rootLayer = new JLayer<JComponent>(rootPanel, new ShadowLayerUI());
        this.getContentPane().add(rootLayer, "Center");
        this.menuPanel = new MainMenuPanel();
        rootPanel.add((Component)this.menuPanel, "cell 0 0, growy");
        JSplitPane splitPane = new JSplitPane();
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(0.5);
        splitPane.setOneTouchExpandable(true);
        splitPane.setName("mainWindow.splitPane");
        rootPanel.add((Component)splitPane, "cell 1 0, grow");
        this.masterPanel = new JPanel();
        this.masterPanel.setLayout(new CardLayout(0, 0));
        splitPane.setLeftComponent(this.masterPanel);
        this.detailPanel = new JPanel();
        this.detailPanel.setLayout(new CardLayout(0, 0));
        splitPane.setRightComponent(this.detailPanel);
        HintManager.getInstance().addHint(TmmResourceBundle.getString("hintmanager.tabs"), this.detailPanel, 2);
        StatusBarPanel panelStatusBar = new StatusBarPanel();
        this.getContentPane().add((Component)panelStatusBar, "South");
        LOGGER.debug("Initializing MovieUIModule...");
        this.addModule(MovieUIModule.getInstance());
        LOGGER.debug("Initializing MovieSetUIModule...");
        this.addModule(MovieSetUIModule.getInstance());
        LOGGER.debug("Initializing TvShowUIModule...");
        this.addModule(TvShowUIModule.getInstance());
        LOGGER.debug("Done initializing UI modules :)");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainWindow.this.closeTmm();
            }
        });
        MessageManager.getInstance().addListener(TmmUIMessageCollector.instance);
        Toolkit.getDefaultToolkit().addAWTEventListener(arg0 -> {
            if (arg0 instanceof MouseEvent) {
                Object patt7587$temp;
                MouseEvent mouseEvent = (MouseEvent)arg0;
                if (((MouseEvent)arg0).isPopupTrigger() && (patt7587$temp = arg0.getSource()) instanceof JTextComponent) {
                    JTextComponent textComponent = (JTextComponent)patt7587$temp;
                    if (mouseEvent.isPopupTrigger() && textComponent.getComponentPopupMenu() == null) {
                        TextFieldPopupMenu.buildCutCopyPaste().show(textComponent, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        }, 16L);
        if (Platform.isLinux() && StringUtils.isBlank((CharSequence)MediaInfo.version())) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("mediainfo.failed.linux")));
        }
        for (ITmmModule module : TmmModuleManager.getInstance().getModules()) {
            if (module.getStartupMessages().isEmpty()) continue;
            for (String message : module.getStartupMessages()) {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, message));
            }
        }
        SwingUtilities.invokeLater(SettingsDialog::getInstance);
        if (Settings.getInstance().isNewConfig()) {
            SwingUtilities.invokeLater(() -> HintManager.getInstance().showHints());
        }
        TmmUILayoutStore.getInstance().install(splitPane);
    }

    private void addModule(ITmmUIModule module) {
        MainTabbedPane tabbedPane = new MainTabbedPane(){

            @Override
            public void updateUI() {
                this.putClientProperty("rightBorder", "half");
                this.putClientProperty("roundEdge", Boolean.FALSE);
                super.updateUI();
            }
        };
        tabbedPane.addTab(module.getTabTitle(), module.getTabPanel());
        this.masterPanel.add((Component)tabbedPane, module.getModuleId());
        this.detailPanel.add((Component)module.getDetailPanel(), module.getModuleId());
        this.menuPanel.addModule(module);
    }

    public void closeTmm() {
        this.closeTmmAndStart(null);
    }

    public void closeTmmAndStart(ProcessBuilder pb) {
        int confirm = 0;
        if (TmmTaskManager.getInstance().isPoolRunning()) {
            Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
            confirm = JOptionPane.showOptionDialog(this, TmmResourceBundle.getString("tmm.exit.runningtasks"), TmmResourceBundle.getString("tmm.exit.confirmation"), 0, 3, null, options, null);
        }
        if (confirm == 0) {
            LOGGER.info("bye bye");
            this.saveWindowLayout();
            TinyMediaManager.shutdown();
            this.dispose();
            if (pb != null) {
                try {
                    LOGGER.info("Going to execute: {}", pb.command());
                    pb.start();
                }
                catch (Exception e) {
                    LOGGER.error("Cannot spawn process:", (Throwable)e);
                }
            }
            TinyMediaManager.shutdownLogger();
            System.exit(0);
        }
    }

    public static JFrame getFrame() {
        return instance;
    }

    public void createLightbox(String pathToFile, String urlToFile) {
        LightBox.showLightBox(instance, pathToFile, urlToFile);
    }

    public void saveWindowLayout() {
        for (Window window : Window.getWindows()) {
            JFrame frame;
            if (window instanceof JDialog) {
                JDialog dialog = (JDialog)window;
                if (!dialog.isVisible()) continue;
                TmmUILayoutStore.getInstance().saveSettings(dialog);
                continue;
            }
            if (!(window instanceof JFrame) || !(frame = (JFrame)window).isVisible()) continue;
            TmmUILayoutStore.getInstance().saveSettings(frame);
        }
    }

    @Override
    public void showModalPopupPanel(ModalPopupPanel popupPanel) {
        Component focusOwner = this.getFocusOwner();
        if (focusOwner != null) {
            this.focusedComponents.push(focusOwner);
        }
        popupPanel.setBounds(this.getContentPane().getBounds());
        this.getLayeredPane().add(popupPanel, this.popupIndex++, 0);
    }

    @Override
    public void hideModalPopupPanel(ModalPopupPanel popupPanel) {
        this.getLayeredPane().remove(popupPanel);
        --this.popupIndex;
        this.validate();
        this.repaint();
        if (!this.focusedComponents.isEmpty()) {
            Component comp = this.focusedComponents.pop();
            comp.requestFocusInWindow();
        }
    }

    void setActiveModule(ITmmUIModule module) {
        this.toolbarPanel.setUIModule(module);
        CardLayout cl = (CardLayout)this.masterPanel.getLayout();
        cl.show(this.masterPanel, module.getModuleId());
        cl = (CardLayout)this.detailPanel.getLayout();
        cl.show(this.detailPanel, module.getModuleId());
        this.updateMenuBar(module);
    }

    private void updateMenuBar(ITmmUIModule uiModule) {
        if (this.topMenuBar != null) {
            this.topMenuBar.removeAll();
            if (uiModule.getUpdateMenu() != null) {
                this.topMenuBar.add(TmmUIMenuHelper.morphJPopupMenuToJMenu(uiModule.getUpdateMenu(), TmmResourceBundle.getString("Toolbar.update")));
            }
            if (uiModule.getSearchMenu() != null) {
                this.topMenuBar.add(TmmUIMenuHelper.morphJPopupMenuToJMenu(uiModule.getSearchMenu(), TmmResourceBundle.getString("Toolbar.search")));
            }
            if (uiModule.getEditMenu() != null) {
                this.topMenuBar.add(TmmUIMenuHelper.morphJPopupMenuToJMenu(uiModule.getEditMenu(), TmmResourceBundle.getString("Toolbar.edit")));
            }
            if (uiModule.getRenameMenu() != null) {
                this.topMenuBar.add(TmmUIMenuHelper.morphJPopupMenuToJMenu(uiModule.getRenameMenu(), TmmResourceBundle.getString("Toolbar.rename")));
            }
            this.topMenuBar.add(TmmUIMenuHelper.morphJPopupMenuToJMenu(this.menuPanel.getToolsMenu(), TmmResourceBundle.getString("Toolbar.tools")));
            this.topMenuBar.add(TmmUIMenuHelper.morphJPopupMenuToJMenu(this.menuPanel.getInfoMenu(), TmmResourceBundle.getString("Toolbar.help")));
            this.topMenuBar.revalidate();
        }
    }
}

