/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class TablePopupListener
extends MouseAdapter {
    private final JPopupMenu popup;
    private final JTable table;

    public TablePopupListener(JPopupMenu popupMenu, JTable table) {
        this.popup = popupMenu;
        this.table = table;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            int[] selectedRows;
            boolean selected = false;
            int row = this.table.rowAtPoint(e.getPoint());
            for (int selectedRow : selectedRows = this.table.getSelectedRows()) {
                if (selectedRow != row) continue;
                selected = true;
            }
            if (!selected) {
                this.table.getSelectionModel().setSelectionInterval(row, row);
            }
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

