/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.table;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.license.License;
import org.tinymediamanager.scraper.util.UrlUtil;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.table.TmmEditorTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.panels.IModalPopupPanelProvider;
import org.tinymediamanager.ui.panels.ModalPopupPanel;
import org.tinymediamanager.ui.panels.TrailerEditorPanel;

public class MediaTrailerTable
extends TmmEditorTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTrailerTable.class);
    private final EventList<MediaTrailer> trailerEventList;
    private final boolean editable;

    public MediaTrailerTable(EventList<MediaTrailer> trailerEventList) {
        this(trailerEventList, false);
    }

    public MediaTrailerTable(EventList<MediaTrailer> trailerEventList, boolean editable) {
        this.trailerEventList = trailerEventList;
        this.editable = editable;
        this.setModel((TableModel)((Object)new TmmTableModel<MediaTrailer>((EventList<MediaTrailer>)GlazedListsSwing.swingThreadProxyList(trailerEventList), new TrailerTableFormat(editable, License.getInstance().isValidLicense()))));
        this.adjustColumnPreferredWidths(3);
    }

    @Override
    protected void editButtonClicked(int row) {
        IModalPopupPanelProvider iModalPopupPanelProvider = IModalPopupPanelProvider.findModalProvider(this);
        if (iModalPopupPanelProvider == null) {
            return;
        }
        MediaTrailer trailer = this.getTrailer(row);
        ModalPopupPanel popupPanel = iModalPopupPanelProvider.createModalPopupPanel();
        popupPanel.setTitle(TmmResourceBundle.getString("trailer.edit"));
        TrailerEditorPanel trailerEditorPanel = new TrailerEditorPanel(trailer);
        popupPanel.setContent(trailerEditorPanel);
        iModalPopupPanelProvider.showModalPopupPanel(popupPanel);
    }

    protected void downloadTrailer(MediaTrailer mediaTrailer) {
    }

    protected String refreshUrlFromId(MediaTrailer trailer) {
        return trailer.getUrl();
    }

    protected void nfoButtonClicked(MediaTrailer trailer) {
        if (!this.editable) {
            return;
        }
        for (MediaTrailer mediaTrailer : this.trailerEventList) {
            if (mediaTrailer.equals(trailer)) {
                mediaTrailer.setInNfo(true);
                continue;
            }
            mediaTrailer.setInNfo(false);
        }
    }

    protected void playTrailer(MediaTrailer trailer) {
        String url = trailer.getUrl();
        if (url.isEmpty()) {
            url = this.refreshUrlFromId(trailer);
        }
        if (StringUtils.isNotBlank((CharSequence)url)) {
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception ex) {
                LOGGER.error("Could not open '{}' in browser - '{}'", (Object)url, (Object)ex.getMessage());
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)trailer.getUrl(), "message.erroropenurl", new String[]{":", ex.getLocalizedMessage()}));
            }
        }
    }

    @Override
    protected boolean isLinkCell(int row, int column) {
        return this.editable && this.isNfoColumn(column) || this.isEditorColumn(column) || this.isDownloadColumn(column) && this.isDownloadUrlAvailable(row) || this.isPlayColumn(column);
    }

    private boolean isDownloadColumn(int column) {
        if (column < 0) {
            return false;
        }
        return "download".equals(this.getColumnModel().getColumn(column).getIdentifier());
    }

    private boolean isDownloadUrlAvailable(int row) {
        if (row >= 0 && row < this.trailerEventList.size()) {
            String url = this.getTrailer(row).getUrl();
            if (url != null && url.startsWith("http")) {
                return true;
            }
            if (!StringUtils.isBlank((CharSequence)this.getTrailer(row).getId())) {
                return true;
            }
        }
        return false;
    }

    private boolean isNfoColumn(int column) {
        if (column < 0) {
            return false;
        }
        return "nfo".equals(this.getColumnModel().getColumn(column).getIdentifier());
    }

    private boolean isPlayColumn(int column) {
        if (column < 0) {
            return false;
        }
        return "play".equals(this.getColumnModel().getColumn(column).getIdentifier());
    }

    private MediaTrailer getTrailer(int row) {
        int index = this.convertRowIndexToModel(row);
        return (MediaTrailer)this.trailerEventList.get(index);
    }

    @Override
    protected void linkClicked(int row, int column, MouseEvent mouseEvent) {
        MediaTrailer trailer = this.getTrailer(row);
        if (trailer != null) {
            if (this.isDownloadColumn(column)) {
                this.downloadTrailer(trailer);
            } else if (this.isPlayColumn(column)) {
                this.playTrailer(trailer);
            } else if (this.isNfoColumn(column)) {
                this.nfoButtonClicked(trailer);
            }
        }
    }

    public void addTrailer() {
        IModalPopupPanelProvider iModalPopupPanelProvider = IModalPopupPanelProvider.findModalProvider(this);
        if (iModalPopupPanelProvider == null) {
            return;
        }
        MediaTrailer trailer = new MediaTrailer();
        ModalPopupPanel popupPanel = iModalPopupPanelProvider.createModalPopupPanel();
        popupPanel.setTitle(TmmResourceBundle.getString("trailer.add"));
        TrailerEditorPanel trailerEditorPanel = new TrailerEditorPanel(trailer);
        popupPanel.setContent(trailerEditorPanel);
        popupPanel.setOnCloseHandler(() -> this.trailerEventList.add((Object)trailer));
        iModalPopupPanelProvider.showModalPopupPanel(popupPanel);
    }

    private static class TrailerTableFormat
    extends TmmTableFormat<MediaTrailer> {
        public TrailerTableFormat(boolean editable, boolean downloadEnabled) {
            TmmTableFormat.Column col;
            TmmTableFormat.StringComparator stringComparator = new TmmTableFormat.StringComparator();
            TmmTableFormat.BooleanComparator booleanComparator = new TmmTableFormat.BooleanComparator();
            TmmTableFormat.ImageComparator imageComparator = new TmmTableFormat.ImageComparator();
            if (!editable && downloadEnabled) {
                col = new TmmTableFormat.Column(this, "", "download", trailer -> {
                    if (StringUtils.isNotBlank((CharSequence)trailer.getUrl()) && trailer.getUrl().toLowerCase(Locale.ROOT).startsWith("http") || !StringUtils.isBlank((CharSequence)trailer.getId())) {
                        return IconManager.DOWNLOAD;
                    }
                    return null;
                }, ImageIcon.class);
                col.setColumnResizeable(false);
                col.setColumnComparator(imageComparator);
                this.addColumn(col);
            }
            col = new TmmTableFormat.Column(this, "", "play", trailer -> IconManager.PLAY, ImageIcon.class);
            col.setColumnResizeable(false);
            col.setColumnComparator(imageComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.nfo"), "nfo", MediaTrailer::getInNfo, Boolean.class);
            col.setColumnResizeable(false);
            col.setColumnComparator(booleanComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.name"), "name", MediaTrailer::getName, String.class);
            col.setCellTooltip(MediaTrailer::getName);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.source"), "source", MediaTrailer::getProvider, String.class);
            col.setCellTooltip(MediaTrailer::getProvider);
            col.setColumnComparator(stringComparator);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.quality"), "quality", MediaTrailer::getQuality, String.class);
            col.setColumnResizeable(false);
            col.setColumnComparator(stringComparator);
            this.addColumn(col);
            if (!editable) {
                col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.format"), "format", trailer -> {
                    String ext = UrlUtil.getExtension(trailer.getUrl()).toLowerCase(Locale.ROOT);
                    if (!Settings.getInstance().getVideoFileType().contains("." + ext)) {
                        ext = "";
                    }
                    return ext;
                }, String.class);
                col.setColumnComparator(stringComparator);
                col.setColumnResizeable(false);
                this.addColumn(col);
            } else {
                col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.url"), "url", MediaTrailer::getUrl, String.class);
                col.setCellTooltip(MediaTrailer::getUrl);
                col.setColumnComparator(stringComparator);
                col.setColumnResizeable(false);
                this.addColumn(col);
                col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Button.edit"), "edit", person -> IconManager.EDIT, ImageIcon.class);
                col.setColumnResizeable(false);
                col.setHeaderIcon(IconManager.EDIT_HEADER);
                this.addColumn(col);
            }
        }
    }
}

