/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.label.LinkLabel;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextPane;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class MessageDialog
extends TmmDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageDialog.class);
    private final JLabel lblImage;
    private final JTextPane tpText;
    private final JTextPane tpDescription;
    private final JScrollPane scrollPane;
    private final JTextPane textPane;
    private final LinkLabel lblLink;

    public MessageDialog(Window owner, String title) {
        super(owner, title, "messageDialog");
        this.setModal(false);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        JPanel panelContent = new JPanel();
        panelContent.setLayout((LayoutManager)new MigLayout("hidemode 3", "[][600lp:800lp,grow]", "[][][][400lp:600lp,grow]"));
        this.getContentPane().add((Component)panelContent, "Center");
        this.lblImage = new JLabel("");
        this.lblImage.setVisible(false);
        panelContent.add((Component)this.lblImage, "cell 0 0 1 2,grow");
        this.tpText = new ReadOnlyTextPane("");
        this.tpText.setVisible(false);
        panelContent.add((Component)this.tpText, "cell 1 0,growx");
        this.tpDescription = new ReadOnlyTextPane("");
        this.tpDescription.setEditable(true);
        this.tpDescription.setVisible(false);
        panelContent.add((Component)this.tpDescription, "cell 1 1,growx");
        this.lblLink = new LinkLabel();
        this.lblLink.setVisible(false);
        this.lblLink.addActionListener(arg0 -> {
            try {
                TmmUIHelper.browseUrl(this.lblLink.getText());
            }
            catch (Exception e) {
                LOGGER.error("Could not open '{}' in browser - '{}'", (Object)this.lblLink.getText(), (Object)e.getMessage());
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.lblLink.getText(), "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        panelContent.add((Component)this.lblLink, "cell 1 2");
        this.scrollPane = new NoBorderScrollPane();
        this.scrollPane.setVisible(false);
        this.scrollPane.setPreferredSize(new Dimension(600, 200));
        panelContent.add((Component)this.scrollPane, "cell 0 3 2 1,grow");
        this.textPane = new JTextPane();
        this.textPane.setVisible(false);
        this.textPane.setEditable(false);
        this.scrollPane.setViewportView(this.textPane);
        JButton btnClose = new JButton(TmmResourceBundle.getString("Button.close"));
        btnClose.addActionListener(arg0 -> this.setVisible(false));
        this.addDefaultButton(btnClose);
    }

    public void setImage(Icon icon) {
        this.lblImage.setIcon(icon);
        this.lblImage.setVisible(true);
    }

    public void setText(String text) {
        this.tpText.setText(text);
        this.tpText.setVisible(true);
    }

    public void setDescription(String description) {
        this.tpDescription.setText(description);
        this.tpDescription.setVisible(true);
    }

    public void setLink(String link) {
        this.lblLink.setText(link);
        this.lblLink.setVisible(true);
    }

    public void setDetails(String details) {
        this.textPane.setText(details);
        this.textPane.setVisible(true);
        this.textPane.setCaretPosition(0);
        this.scrollPane.setVisible(true);
    }

    public static void showExceptionWindow(Throwable ex) {
        MessageDialog dialog = new MessageDialog(null, TmmResourceBundle.getString("tmm.problemdetected"));
        dialog.setImage(IconManager.ERROR);
        if (ex instanceof OutOfMemoryError) {
            dialog.setDescription(TmmResourceBundle.getString("tmm.oom"));
            dialog.setLink("https://www.tinymediamanager.org/help/faq#java-heap-space-errors");
        } else {
            String msg = ex.getLocalizedMessage();
            dialog.setText(msg != null ? msg : "");
            dialog.setDescription(TmmResourceBundle.getString("tmm.uicrash"));
        }
        dialog.setDetails(MessageDialog.stackStraceAsString(ex));
        dialog.setVisible(true);
    }

    private static String stackStraceAsString(Throwable ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

