/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUILayoutStore;

public class TmmOptionDialog
extends JDialog {
    private int result = 1;

    private TmmOptionDialog(Frame owner, Icon icon, String title, String message, JCheckBox chkbxOption) {
        super(owner, title, true);
        String[] lines;
        this.setName("message");
        this.setLayout(new BorderLayout());
        JPanel panelContent = new JPanel((LayoutManager)new MigLayout("hidemode 3", "10lp[50lp]10lp[500lp, grow]10lp", "10lp[10lp, center][10lp, center]"));
        this.add((Component)panelContent, "Center");
        if (icon != null) {
            panelContent.add((Component)new JLabel(icon), "cell 0 0 1 2, center, grow");
        } else {
            panelContent.add((Component)new JLabel(IconManager.QUESTION_BIG), "cell 0 0 1 2, center, grow");
        }
        for (String line : lines = message.split("\n")) {
            JLabel lblMessage = new JLabel(line);
            panelContent.add((Component)lblMessage, "cell 1 0, aligny center, flowy");
        }
        if (chkbxOption != null) {
            panelContent.add((Component)chkbxOption, "cell 1 1, aligny center, grow, wmin 0");
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        final JButton btnOk = new JButton(TmmResourceBundle.getString("Button.yes"));
        btnOk.addActionListener(e -> {
            this.result = 0;
            this.setVisible(false);
        });
        JButton btnCancel = new JButton(TmmResourceBundle.getString("Button.no"));
        btnCancel.addActionListener(e -> {
            this.result = 1;
            this.setVisible(false);
        });
        buttonPanel.add(btnOk);
        buttonPanel.add(btnCancel);
        this.add((Component)buttonPanel, "South");
        this.getRootPane().setDefaultButton(btnOk);
        this.setLocationRelativeTo(owner);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                btnOk.requestFocusInWindow();
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.pack();
            TmmUILayoutStore.getInstance().loadSettings(this);
            super.setVisible(true);
            this.toFront();
        } else {
            TmmUILayoutStore.getInstance().saveSettings(this);
            super.setVisible(false);
            this.dispose();
        }
    }

    public static int showOptionDialog(Frame owner, Icon icon, String title, String message, JCheckBox chkbxOption) {
        TmmOptionDialog dialog = new TmmOptionDialog(owner, icon, title, message, chkbxOption);
        dialog.setVisible(true);
        return dialog.result;
    }

    public static int showOptionDialog(Frame owner, Icon icon, String title, String message) {
        return TmmOptionDialog.showOptionDialog(owner, icon, title, message, null);
    }

    public static int showOptionDialog(Frame owner, String title, String message) {
        return TmmOptionDialog.showOptionDialog(owner, null, title, message, null);
    }

    public static int showOptionDialog(Frame owner, String title, String message, JCheckBox chkbxOption) {
        return TmmOptionDialog.showOptionDialog(owner, null, title, message, chkbxOption);
    }
}

