/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import javax.swing.JLabel;
import javax.swing.SpinnerNumberModel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractNumberMovieFilter;

public class MovieVideoBitrateFilter
extends AbstractNumberMovieFilter {
    public MovieVideoBitrateFilter() {
        this.spinnerLow.setEditor(this.prepareNumberEditor(this.spinnerLow, "#####0 kbps"));
        this.spinnerHigh.setEditor(this.prepareNumberEditor(this.spinnerHigh, "#####0 kbps"));
    }

    @Override
    public String getId() {
        return "movieVideoBitrate";
    }

    @Override
    protected SpinnerNumberModel getNumberModel() {
        return new SpinnerNumberModel(0, 0, 999999, 1);
    }

    @Override
    public boolean accept(Movie movie) {
        return this.matchInt(movie.getMainVideoFile().getVideoBitRate());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.bitrate"));
    }
}

