/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.moviesets.dialogs.MovieSetPostProcessDialog;

public class MovieSetPostProcessingSettingsPanel
extends JPanel {
    private final MovieSettings settings = MovieModuleManager.getInstance().getSettings();
    private TmmTable tablePostProcesses;
    private JButton btnRemoveProcess;
    private JButton btnAddProcess;
    private JButton btnEditProcess;

    MovieSetPostProcessingSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnAddProcess.addActionListener(e -> {
            MovieSetPostProcessDialog dialog = new MovieSetPostProcessDialog();
            dialog.pack();
            dialog.setLocationRelativeTo(MainWindow.getInstance());
            dialog.setVisible(true);
            this.tablePostProcesses.adjustColumnPreferredWidths(5);
        });
        this.btnRemoveProcess.addActionListener(e -> {
            int[] indexRows;
            for (int indexRow : indexRows = TmmUIHelper.getSelectedRowsAsModelRows(this.tablePostProcesses)) {
                try {
                    PostProcess process = this.settings.getMovieSetPostProcess().get(indexRow);
                    this.settings.removeMovieSetPostProcess(process);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.tablePostProcesses.adjustColumnPreferredWidths(5);
        });
        this.btnEditProcess.addActionListener(e -> {
            PostProcess process;
            int row = this.tablePostProcesses.getSelectedRow();
            if ((row = this.tablePostProcesses.convertRowIndexToModel(row)) != -1 && (process = this.settings.getMovieSetPostProcess().get(row)) != null) {
                MovieSetPostProcessDialog dialog = new MovieSetPostProcessDialog();
                dialog.setProcess(process);
                dialog.pack();
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                this.tablePostProcesses.adjustColumnPreferredWidths(5);
            }
        });
        this.tablePostProcesses.getColumnModel().getColumn(0).setHeaderValue(TmmResourceBundle.getString("Settings.processname"));
        this.tablePostProcesses.getColumnModel().getColumn(1).setHeaderValue(TmmResourceBundle.getString("metatag.path"));
        this.tablePostProcesses.getColumnModel().getColumn(2).setHeaderValue(TmmResourceBundle.getString("Settings.commandname"));
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[]"));
        JPanel panelProcess = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][600lp,grow][]", "[500lp,grow]"));
        TmmLabel lblProcess = new TmmLabel(TmmResourceBundle.getString("Settings.postprocessing"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelProcess, lblProcess, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#post-processing"));
        this.add((Component)collapsiblePanel, "growx,wmin 0");
        JScrollPane spProcesses = new JScrollPane();
        panelProcess.add((Component)spProcesses, "cell 1 0,grow");
        this.tablePostProcesses = new TmmTable();
        this.tablePostProcesses.configureScrollPane(spProcesses);
        this.btnAddProcess = new JButton(TmmResourceBundle.getString("Button.add"));
        panelProcess.add((Component)this.btnAddProcess, "flowy,cell 2 0,growx,aligny top");
        this.btnEditProcess = new JButton(TmmResourceBundle.getString("Button.edit"));
        panelProcess.add((Component)this.btnEditProcess, "cell 2 0,growx");
        this.btnRemoveProcess = new JButton(TmmResourceBundle.getString("Button.remove"));
        panelProcess.add((Component)this.btnRemoveProcess, "cell 2 0,growx");
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"movieSetPostProcess");
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (JTable)this.tablePostProcesses);
        BeanProperty wolBeanProperty_1 = BeanProperty.create((String)"name");
        jTableBinding.addColumnBinding((Property)wolBeanProperty_1);
        BeanProperty wolBeanProperty_3 = BeanProperty.create((String)"path");
        jTableBinding.addColumnBinding((Property)wolBeanProperty_3);
        BeanProperty wolBeanProperty_4 = BeanProperty.create((String)"command");
        jTableBinding.addColumnBinding((Property)wolBeanProperty_4);
        jTableBinding.setEditable(false);
        jTableBinding.bind();
    }
}

