/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.ui.components.label.ImageLabel;
import org.tinymediamanager.ui.images.TmmSvgIcon;

public abstract class InformationPanel
extends JPanel {
    protected final Map<MediaFileType, List<Component>> artworkComponents = new EnumMap<MediaFileType, List<Component>>(MediaFileType.class);

    protected abstract List<MediaFileType> getShowArtworkFromSettings();

    protected abstract void setColumnLayout(boolean var1);

    protected List<Component> generateArtworkComponents(MediaFileType mediaFileType) {
        ArrayList<Component> components = new ArrayList<Component>();
        ImageLabel imageLabel = new ImageLabel(false, false, true);
        switch (mediaFileType) {
            case POSTER: 
            case SEASON_POSTER: {
                imageLabel.setDesiredAspectRatio(0.6666667f);
                break;
            }
            case FANART: 
            case THUMB: 
            case SEASON_FANART: 
            case SEASON_THUMB: {
                imageLabel.setDesiredAspectRatio(1.7777778f);
                break;
            }
            case BANNER: 
            case SEASON_BANNER: {
                imageLabel.setDesiredAspectRatio(3.125f);
                break;
            }
            case CLEARLOGO: {
                imageLabel.setDesiredAspectRatio(2.58f);
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        imageLabel.setCursor(Cursor.getPredefinedCursor(12));
        imageLabel.enableLightbox();
        components.add(imageLabel);
        JLabel lblArtworkSize = new JLabel(TmmResourceBundle.getString("mediafiletype." + mediaFileType.name().toLowerCase(Locale.ROOT)));
        components.add(lblArtworkSize);
        components.add(Box.createVerticalStrut(20));
        this.artworkComponents.put(mediaFileType, components);
        return components;
    }

    protected void setArtwork(MediaEntity mediaEntity, MediaFileType type) {
        this.setArtwork(ListUtils.getFirst(mediaEntity.getMediaFiles(type)), type);
    }

    protected void setArtwork(MediaFile mediaFile, MediaFileType type) {
        List<Component> components = this.artworkComponents.get((Object)type);
        if (ListUtils.isEmpty(components)) {
            return;
        }
        boolean visible = this.getShowArtworkFromSettings().contains((Object)type);
        for (Component component : components) {
            component.setVisible(visible);
            if (component instanceof ImageLabel) {
                ImageLabel imageLabel = (ImageLabel)component;
                imageLabel.setImageMediaFile(mediaFile);
                continue;
            }
            if (!(component instanceof JLabel)) continue;
            JLabel sizeLabel = (JLabel)component;
            Dimension artworkDimension = MediaFileHelper.getArtworkDimension(mediaFile);
            if (artworkDimension.width > 0 && artworkDimension.height > 0) {
                sizeLabel.setText(TmmResourceBundle.getString("mediafiletype." + type.name().toLowerCase(Locale.ROOT)) + " - " + artworkDimension.width + "x" + artworkDimension.height);
                continue;
            }
            sizeLabel.setText(TmmResourceBundle.getString("mediafiletype." + type.name().toLowerCase(Locale.ROOT)));
        }
        this.updateArtwork();
    }

    protected void updateArtwork() {
        boolean visible = false;
        block0: for (List<Component> components : this.artworkComponents.values()) {
            for (Component component : components) {
                if (!component.isVisible()) continue;
                visible = true;
                continue block0;
            }
        }
        this.setColumnLayout(visible);
        this.revalidate();
    }

    protected Icon getCertificationIcon(MediaCertification cert) {
        if (cert == null || cert == MediaCertification.UNKNOWN) {
            return null;
        }
        try {
            URI uri = this.getClass().getResource("/org/tinymediamanager/ui/images/certification/" + cert.name().toLowerCase(Locale.ROOT) + ".svg").toURI();
            TmmSvgIcon icon = new TmmSvgIcon(uri);
            icon.setPreferredHeight(32);
            icon.setAutosize(4);
            if (cert.getCountry() == CountryCode.US) {
                icon.setColor(UIManager.getColor("Label.foreground"), "#000000");
            }
            return icon;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getIntegerAsStringWoZero(Integer integer) {
        if (integer == null || integer.equals(0)) {
            return "";
        }
        return String.valueOf(integer);
    }

    protected String convertRuntime(Integer runtimeInMinutes) {
        if (runtimeInMinutes == null || runtimeInMinutes.equals(0)) {
            return "";
        }
        long h = TimeUnit.MINUTES.toHours(runtimeInMinutes.intValue());
        long m = TimeUnit.MINUTES.toMinutes((long)runtimeInMinutes.intValue() - TimeUnit.HOURS.toMinutes(h));
        if (h > 0L) {
            return String.format("%dh %02dm", h, m);
        }
        return String.format("%dm", m);
    }
}

