/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.util.Locale;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.IMediaInformation;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.ui.WrapLayout;
import org.tinymediamanager.ui.images.AspectRatioIcon;
import org.tinymediamanager.ui.images.AudioChannelsIcon;
import org.tinymediamanager.ui.images.GenericAudioCodecIcon;
import org.tinymediamanager.ui.images.GenericVideoCodecIcon;
import org.tinymediamanager.ui.images.MediaInfoIcon;
import org.tinymediamanager.ui.images.VideoFormatIcon;

public class MediaInformationLogosPanel
extends JPanel {
    private IMediaInformation mediaInformationSource;
    private final JLabel lblVideoFormat;
    private final JLabel lblAspectRatio;
    private final JLabel lblVideoCodec;
    private final JLabel lblVideo3d;
    private final JLabel lblVideoHdr1;
    private final JLabel lblVideoHdr2;
    private final JLabel lblVideoHdr3;
    private final JLabel lblAudioCodec;
    private final JLabel lblAudioCodec2;
    private final JLabel lblAudioChannels;
    private final JLabel lblSource;
    private final JLabel lblHfr;

    public MediaInformationLogosPanel() {
        this.setLayout(new WrapLayout(0));
        this.lblVideoFormat = new JLabel();
        this.lblAspectRatio = new JLabel();
        this.lblVideoCodec = new JLabel();
        this.lblVideo3d = new JLabel();
        this.lblVideoHdr1 = new JLabel();
        this.lblVideoHdr2 = new JLabel();
        this.lblVideoHdr3 = new JLabel();
        this.lblAudioChannels = new JLabel();
        this.lblAudioCodec = new JLabel();
        this.lblAudioCodec2 = new JLabel();
        this.lblSource = new JLabel();
        this.lblHfr = new JLabel();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.mediaInformationSource != null) {
            this.updateIcons();
        }
    }

    public void setMediaInformationSource(IMediaInformation source) {
        this.mediaInformationSource = source;
        this.updateIcons();
    }

    private void updateIcons() {
        this.removeAll();
        this.setIcon(this.lblVideoFormat, this.getVideoFormatIcon());
        this.setIcon(this.lblAspectRatio, this.getAspectRatioIcon());
        this.setIcon(this.lblVideoCodec, this.getVideoCodecIcon(0));
        this.setIcon(this.lblVideo3d, this.getVideo3dIcon());
        this.setIcon(this.lblVideoHdr1, this.getVideoHdrIcon(0));
        this.setIcon(this.lblVideoHdr2, this.getVideoHdrIcon(1));
        this.setIcon(this.lblVideoHdr3, this.getVideoHdrIcon(2));
        int videoComponentCount = this.getComponentCount();
        if (videoComponentCount > 0) {
            this.add(Box.createHorizontalStrut(15));
        }
        this.setIcon(this.lblAudioCodec, this.getAudioCodecIcon(0));
        this.setIcon(this.lblAudioCodec2, this.getAudioCodecIcon(1));
        this.setIcon(this.lblAudioChannels, this.getAudioChannelsIcon());
        int audioComponentCount = this.getComponentCount() - videoComponentCount;
        if (audioComponentCount > 0) {
            this.add(Box.createHorizontalStrut(15));
        }
        this.setIcon(this.lblSource, this.getSourceIcon());
        this.setIcon(this.lblHfr, this.getHfrIcon());
        this.revalidate();
        this.repaint();
    }

    private void setIcon(JLabel label, Icon icon) {
        label.setIcon(icon);
        if (icon != null) {
            this.add(label);
        }
    }

    private Icon getVideoFormatIcon() {
        String videoFormat = Utils.cleanFilename(this.mediaInformationSource.getMediaInfoVideoFormat());
        if (StringUtils.isBlank((CharSequence)videoFormat)) {
            return null;
        }
        try {
            return new VideoFormatIcon(videoFormat);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Icon getAspectRatioIcon() {
        float aspectRatio = this.mediaInformationSource.getMediaInfoAspectRatio();
        if (aspectRatio == 0.0f) {
            return null;
        }
        try {
            return new AspectRatioIcon(String.format(Locale.US, "%.2f", Float.valueOf(aspectRatio)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Icon getVideoCodecIcon(int num) {
        String videoCodec = this.mediaInformationSource.getMediaInfoVideoCodec();
        if (StringUtils.isBlank((CharSequence)videoCodec)) {
            return null;
        }
        String[] split = videoCodec.split("/");
        int i = 0;
        for (String codec : split) {
            if (num == i) {
                try {
                    return new MediaInfoIcon("video/codec/" + codec.toLowerCase(Locale.ROOT).replaceAll("^v_", "") + ".svg");
                }
                catch (Exception e) {
                    try {
                        return new GenericVideoCodecIcon(codec);
                    }
                    catch (Exception e1) {
                        return null;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private Icon getAudioCodecIcon(int num) {
        String audioCodec = this.mediaInformationSource.getMediaInfoAudioCodec();
        if (StringUtils.isBlank((CharSequence)audioCodec)) {
            return null;
        }
        String[] split = audioCodec.split("/");
        int i = 0;
        for (String codec : split) {
            if (num == i) {
                try {
                    return new MediaInfoIcon("audio/codec/" + codec.toLowerCase(Locale.ROOT).replaceAll("^a_", "") + ".svg");
                }
                catch (Exception e) {
                    try {
                        return new GenericAudioCodecIcon(audioCodec);
                    }
                    catch (Exception e1) {
                        return null;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private Icon getAudioChannelsIcon() {
        int audioChannelsInt;
        try {
            audioChannelsInt = Integer.parseInt(this.mediaInformationSource.getMediaInfoAudioChannels().replace("ch", ""));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        if (audioChannelsInt == 0) {
            return null;
        }
        String text = MediaFileHelper.audioChannelInDotNotation(audioChannelsInt);
        try {
            return new AudioChannelsIcon(text);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Icon getVideo3dIcon() {
        if (!this.mediaInformationSource.isVideoIn3D()) {
            return null;
        }
        try {
            return new MediaInfoIcon("video/3d.svg");
        }
        catch (Exception e) {
            return null;
        }
    }

    private Icon getVideoHdrIcon(int num) {
        String hdrFormat = this.mediaInformationSource.getVideoHDRFormat();
        if (StringUtils.isBlank((CharSequence)hdrFormat)) {
            return null;
        }
        String[] split = hdrFormat.split(", ");
        int i = 0;
        for (String hdr : split) {
            if (num == i) {
                try {
                    return new MediaInfoIcon("video/" + hdr.toLowerCase(Locale.ROOT).replace(" ", "_") + ".svg");
                }
                catch (Exception e) {
                    try {
                        return new GenericVideoCodecIcon(hdr);
                    }
                    catch (Exception e1) {
                        return null;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private Icon getSourceIcon() {
        MediaSource source = this.mediaInformationSource.getMediaInfoSource();
        if (source == MediaSource.UNKNOWN) {
            return null;
        }
        try {
            return new MediaInfoIcon("source/" + source.name().toLowerCase(Locale.ROOT) + ".svg");
        }
        catch (Exception e) {
            return null;
        }
    }

    private Icon getHfrIcon() {
        double framerate = this.mediaInformationSource.getMediaInfoFrameRate();
        try {
            return framerate >= 48.0 ? new MediaInfoIcon("video/hfr.svg") : null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

