/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import com.google.gson.Gson;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.scraper.config.MediaProviderConfig;
import org.tinymediamanager.scraper.config.MediaProviderConfigObject;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBox;
import org.tinymediamanager.ui.components.label.TmmLabel;

public class MediaScraperConfigurationPanel
extends JPanel {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages");
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaScraperConfigurationPanel.class);
    private final IMediaProvider mediaProvider;
    private final JPanel configPanel;
    private boolean dirty = false;

    public MediaScraperConfigurationPanel(IMediaProvider mediaProvider) {
        this.mediaProvider = mediaProvider;
        this.setLayout((LayoutManager)new MigLayout("insets 0", "[grow]", "20lp![]10lp![grow]"));
        JPanel panelHead = new JPanel(new FlowLayout(0, 0, 0));
        this.add((Component)panelHead, "cell 0 0, growx, wmin 0");
        TmmLabel lblScraperOptions = new TmmLabel(TmmResourceBundle.getString("Settings.scraper.options"), 1.2);
        panelHead.add(lblScraperOptions);
        this.configPanel = this.createConfigPanel();
        this.add((Component)this.configPanel, "cell 0 1, grow, wmin 0");
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                if (MediaScraperConfigurationPanel.this.dirty) {
                    MediaScraperConfigurationPanel.this.saveSettings();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }
        });
    }

    private JPanel createConfigPanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("gapy 2lp, insets 0", "[][20lp!][200lp,grow]", ""));
        int row = 0;
        MediaProviderConfig config = this.mediaProvider.getProviderInfo().getConfig();
        for (Map.Entry<String, MediaProviderConfigObject> entry : config.getConfigObjects().entrySet()) {
            if (!entry.getValue().isVisible()) continue;
            String keyDescription = this.getStringFromBundle("scraper." + this.mediaProvider.getProviderInfo().getId() + "." + entry.getKey());
            if (StringUtils.isBlank((CharSequence)keyDescription)) {
                keyDescription = this.getStringFromBundle(entry.getValue().getKeyDescription());
            }
            if (StringUtils.isBlank((CharSequence)keyDescription)) {
                keyDescription = entry.getValue().getKeyDescription();
            }
            if (entry.getValue().getType() == MediaProviderConfigObject.ConfigType.LABEL) {
                panel.add((Component)new TmmLabel(keyDescription), "cell 0 " + row + " 3 1, gaptop 10lp");
            } else {
                panel.add((Component)new JLabel(keyDescription), "cell 0 " + row);
            }
            JComponent comp = null;
            switch (entry.getValue().getType()) {
                case LABEL: {
                    break;
                }
                case BOOL: {
                    JCheckBox checkbox = new JCheckBox();
                    checkbox.setSelected(entry.getValue().getValueAsBool());
                    checkbox.addActionListener(e -> {
                        this.dirty = true;
                    });
                    comp = checkbox;
                    break;
                }
                case INTEGER: {
                    JSpinner spinner = new JSpinner(new SpinnerNumberModel(entry.getValue().getValueAsInteger(), 0, Integer.MAX_VALUE, 1));
                    spinner.addChangeListener(e -> {
                        this.dirty = true;
                    });
                    ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setColumns(5);
                    comp = spinner;
                    break;
                }
                case SELECT: 
                case SELECT_INDEX: {
                    JComboBox<String> combobox = new JComboBox<String>(entry.getValue().getPossibleValues().toArray(new String[0]));
                    combobox.setSelectedItem(entry.getValue().getValueAsString());
                    combobox.addActionListener(e -> {
                        this.dirty = true;
                    });
                    comp = combobox;
                    break;
                }
                case MULTI_SELECT: {
                    TmmCheckComboBox<String> checkComboBox = new TmmCheckComboBox<String>(entry.getValue().getPossibleValues().toArray(new String[0]));
                    String valuesAsString = entry.getValue().getValueAsString();
                    if (StringUtils.isNotBlank((CharSequence)valuesAsString)) {
                        String[] values = (String[])new Gson().fromJson(valuesAsString, String[].class);
                        checkComboBox.setSelectedItems((String[])values);
                    }
                    checkComboBox.addActionListener(e -> {
                        this.dirty = true;
                    });
                    comp = checkComboBox;
                    break;
                }
                default: {
                    JTextField tf = entry.getValue().isEncrypt() ? new JPasswordField(config.getValue(entry.getKey())) : new JTextField(config.getValue(entry.getKey()));
                    tf.setColumns(20);
                    tf.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            MediaScraperConfigurationPanel.this.dirty = true;
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            MediaScraperConfigurationPanel.this.dirty = true;
                        }

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            MediaScraperConfigurationPanel.this.dirty = true;
                        }
                    });
                    comp = tf;
                }
            }
            if (comp != null) {
                comp.putClientProperty(entry.getKey(), entry.getKey());
                panel.add((Component)comp, "cell 2 " + row);
            }
            try {
                String desc = this.getStringFromBundle("scraper." + this.mediaProvider.getProviderInfo().getId() + "." + entry.getKey() + ".desc");
                if (StringUtils.isNotBlank((CharSequence)desc)) {
                    JLabel lblHint = new JLabel(IconManager.HINT);
                    lblHint.setToolTipText(desc);
                    panel.add((Component)lblHint, "cell 2 " + row);
                }
            }
            catch (Exception e2) {
                LOGGER.debug("failed to add a hint: {}", (Object)e2.getMessage());
            }
            ++row;
        }
        return panel;
    }

    private String getStringFromBundle(String key) {
        if (this.mediaProvider.getProviderInfo().getResourceBundle() != null) {
            try {
                return this.mediaProvider.getProviderInfo().getResourceBundle().getString(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return BUNDLE.getString(key);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void saveSettings() {
        Map<String, MediaProviderConfigObject> config = this.mediaProvider.getProviderInfo().getConfig().getConfigObjects();
        for (Map.Entry<String, MediaProviderConfigObject> entry : config.entrySet()) {
            for (Component comp : this.configPanel.getComponents()) {
                if (!(comp instanceof JComponent)) continue;
                Object param = ((JComponent)comp).getClientProperty(entry.getKey());
                if (!entry.getKey().equals(param)) continue;
                try {
                    if (comp instanceof JCheckBox) {
                        this.mediaProvider.getProviderInfo().getConfig().setValue(entry.getKey(), ((JCheckBox)comp).isSelected());
                        continue;
                    }
                    if (comp instanceof TmmCheckComboBox) {
                        this.mediaProvider.getProviderInfo().getConfig().setValue(entry.getKey(), ((TmmCheckComboBox)comp).getSelectedItems().toString());
                        continue;
                    }
                    if (comp instanceof JComboBox) {
                        this.mediaProvider.getProviderInfo().getConfig().setValue(entry.getKey(), ((JComboBox)comp).getSelectedItem().toString());
                        continue;
                    }
                    if (comp instanceof JSpinner) {
                        this.mediaProvider.getProviderInfo().getConfig().setValue(entry.getKey(), (Integer)((JSpinner)comp).getValue());
                        continue;
                    }
                    this.mediaProvider.getProviderInfo().getConfig().setValue(entry.getKey(), StringUtils.strip((String)((JTextField)comp).getText()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.mediaProvider.getProviderInfo().getConfig().save();
    }
}

