/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import java.util.regex.Matcher;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractTextTvShowUIFilter;

public class TvShowCastFilter
extends AbstractTextTvShowUIFilter {
    @Override
    public String getId() {
        return "tvShowCast";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        if (StringUtils.isBlank((CharSequence)this.normalizedFilterText)) {
            return true;
        }
        try {
            boolean foundShow = false;
            for (Person actor : tvShow.getActors()) {
                Matcher matcher = this.filterPattern.matcher(StrgUtils.normalizeString(actor.getName()));
                if (!matcher.find()) continue;
                foundShow = true;
            }
            if (!invert && foundShow) {
                return true;
            }
            if (invert && foundShow) {
                return false;
            }
            for (TvShowEpisode episode : episodes) {
                Matcher matcher;
                boolean foundGuest = false;
                boolean foundWriter = false;
                boolean foundDirector = false;
                for (Person director : episode.getCrew()) {
                    if (!StringUtils.isNotBlank((CharSequence)director.getName()) || !(matcher = this.filterPattern.matcher(StrgUtils.normalizeString(director.getName()))).find()) continue;
                    foundDirector = true;
                    break;
                }
                for (Person writer : episode.getWriters()) {
                    if (!StringUtils.isNotBlank((CharSequence)writer.getName()) || !(matcher = this.filterPattern.matcher(StrgUtils.normalizeString(writer.getName()))).find()) continue;
                    foundWriter = true;
                    break;
                }
                for (Person actor : episode.getActors()) {
                    if (!StringUtils.isNotBlank((CharSequence)actor.getName()) || !(matcher = this.filterPattern.matcher(StrgUtils.normalizeString(actor.getName()))).find()) continue;
                    foundGuest = true;
                    break;
                }
                if (invert && !foundDirector && !foundWriter && !foundGuest) {
                    return true;
                }
                if (invert || !foundDirector && !foundWriter && !foundGuest) continue;
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.cast"));
    }
}

