/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.wizard;

import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.combobox.LocaleComboBox;
import org.tinymediamanager.ui.components.label.ImageLabel;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextArea;

class UiSettingsPanelLite
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(UiSettingsPanelLite.class);
    private static final Integer[] DEFAULT_FONT_SIZES = new Integer[]{12, 14, 16, 18, 20, 22, 24, 26, 28};
    private final Settings settings = Settings.getInstance();
    private final List<LocaleComboBox> locales = new ArrayList<LocaleComboBox>();
    private JComboBox cbLanguage;
    private ImageLabel lblLight;
    private ImageLabel lblDark;
    private JRadioButton rdbtnLight;
    private JRadioButton rdbtnDark;
    private JComboBox cbFontSize;
    private JComboBox cbFontFamily;
    private JLabel lblUpdate;
    private JLabel lblUpdateInterval;
    private JSpinner spUpdateInterval;
    private JCheckBox chckbxAutomaticUpdates;
    private JLabel lblUpdateHint;

    public UiSettingsPanelLite() {
        LocaleComboBox actualLocale = null;
        LocaleComboBox fallbackLocale = null;
        Locale settingsLang = Utils.getLocaleFromLanguage(this.settings.getLanguage());
        for (Locale l : Utils.getLanguages()) {
            LocaleComboBox localeComboBox = new LocaleComboBox(l);
            this.locales.add(localeComboBox);
            if (l.equals(settingsLang)) {
                actualLocale = localeComboBox;
            }
            if (!settingsLang.getLanguage().equals(l.getLanguage())) continue;
            fallbackLocale = localeComboBox;
        }
        Collections.sort(this.locales);
        this.initComponents();
        if (actualLocale != null) {
            this.cbLanguage.setSelectedItem(actualLocale);
        } else {
            this.cbLanguage.setSelectedItem(fallbackLocale);
        }
        this.cbFontFamily.setSelectedItem(this.settings.getFontFamily());
        int index = this.cbFontFamily.getSelectedIndex();
        if (index < 0) {
            this.cbFontFamily.setSelectedItem("Dialog");
            index = this.cbFontFamily.getSelectedIndex();
        }
        if (index < 0) {
            this.cbFontFamily.setSelectedIndex(0);
        }
        this.cbFontSize.setSelectedItem(this.settings.getFontSize());
        index = this.cbFontSize.getSelectedIndex();
        if (index < 0) {
            this.cbFontSize.setSelectedIndex(0);
        }
        if ("Dark".equals(this.settings.getTheme())) {
            this.rdbtnDark.setSelected(true);
        } else {
            this.rdbtnLight.setSelected(true);
        }
        this.chckbxAutomaticUpdates.setSelected(this.settings.isEnableAutomaticUpdate());
        this.spUpdateInterval.setValue(this.settings.getAutomaticUpdateInterval());
        ActionListener actionListener = e -> this.checkChanges();
        this.cbLanguage.addActionListener(actionListener);
        this.cbFontFamily.addActionListener(actionListener);
        this.cbFontSize.addActionListener(actionListener);
        this.rdbtnLight.addActionListener(actionListener);
        this.rdbtnDark.addActionListener(actionListener);
        this.lblLight.addBoundedMouseListener(new MouseClickEventProxy(this.rdbtnLight));
        this.lblDark.addBoundedMouseListener(new MouseClickEventProxy(this.rdbtnDark));
        this.chckbxAutomaticUpdates.addActionListener(actionListener);
        if (Boolean.parseBoolean(System.getProperty("tmm.noupdate")) || ReleaseInfo.isNightly()) {
            this.lblUpdate.setVisible(false);
            this.chckbxAutomaticUpdates.setSelected(false);
            this.chckbxAutomaticUpdates.setVisible(false);
            this.lblUpdateInterval.setVisible(false);
            this.spUpdateInterval.setVisible(false);
            this.lblUpdateHint.setVisible(false);
        }
    }

    private void initComponents() {
        InputStream is;
        this.setLayout((LayoutManager)new MigLayout("", "[20lp!][200lp,grow][200lp,grow]", "[][][10lp!][][10lp!][][300lp,grow][][10lp!][][][][15lp!][][][][]"));
        JLabel lblUiSettings = new JLabel(TmmResourceBundle.getString("wizard.ui"));
        TmmFontHelper.changeFont(lblUiSettings, 1.3333, 1);
        this.add((Component)lblUiSettings, "cell 0 0 3 1,growx, wmin 0");
        ReadOnlyTextArea taSettingsHint = new ReadOnlyTextArea(TmmResourceBundle.getString("wizard.ui.hint"));
        this.add((Component)taSettingsHint, "cell 1 1 2 1,growx, wmin 0");
        JLabel lblLanguageT = new JLabel(TmmResourceBundle.getString("Settings.language"));
        this.add((Component)lblLanguageT, "flowx,cell 1 3 2 1");
        this.cbLanguage = new JComboBox<Object>(this.locales.toArray());
        this.add((Component)this.cbLanguage, "cell 1 3 2 1");
        JLabel lblThemeT = new JLabel(TmmResourceBundle.getString("Settings.uitheme"));
        this.add((Component)lblThemeT, "cell 1 5");
        this.lblLight = new ImageLabel(false);
        try {
            is = UiSettingsPanelLite.class.getResourceAsStream("light.png");
            try {
                this.lblLight.setOriginalImage(IOUtils.toByteArray((InputStream)is));
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("could not load image: {}", (Object)e.getMessage());
        }
        this.add((Component)this.lblLight, "cell 1 6");
        this.lblDark = new ImageLabel(false);
        try {
            is = UiSettingsPanelLite.class.getResourceAsStream("dark.png");
            try {
                this.lblDark.setOriginalImage(IOUtils.toByteArray((InputStream)is));
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("could not load image: {}", (Object)e.getMessage());
        }
        this.add((Component)this.lblDark, "cell 2 6");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rdbtnLight = new JRadioButton(TmmResourceBundle.getString("Settings.uitheme.light"));
        buttonGroup.add(this.rdbtnLight);
        this.add((Component)this.rdbtnLight, "cell 1 7,alignx left");
        this.rdbtnDark = new JRadioButton(TmmResourceBundle.getString("Settings.uitheme.dark"));
        buttonGroup.add(this.rdbtnDark);
        this.add((Component)this.rdbtnDark, "cell 2 7,alignx left");
        JLabel lblFontT = new JLabel(TmmResourceBundle.getString("Settings.font"));
        this.add((Component)lblFontT, "flowx,cell 1 9 2 1");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.cbFontFamily = new JComboBox<String>(env.getAvailableFontFamilyNames());
        this.add((Component)this.cbFontFamily, "cell 1 9 2 1");
        JLabel lblSize = new JLabel(TmmResourceBundle.getString("Settings.fontsize"));
        this.add((Component)lblSize, "flowx,cell 1 10");
        this.cbFontSize = new JComboBox<Integer>(DEFAULT_FONT_SIZES);
        this.add((Component)this.cbFontSize, "cell 1 10");
        ReadOnlyTextArea taFontHint = new ReadOnlyTextArea(TmmResourceBundle.getString("Settings.fonts.hint"));
        this.add((Component)taFontHint, "cell 1 11 2 1,grow, wmin 0");
        this.lblUpdate = new JLabel(TmmResourceBundle.getString("Settings.update"));
        TmmFontHelper.changeFont(this.lblUpdate, 1.3333, 1);
        this.add((Component)this.lblUpdate, "cell 0 13 3 1");
        this.chckbxAutomaticUpdates = new JCheckBox(TmmResourceBundle.getString("Settings.updatecheck"));
        this.add((Component)this.chckbxAutomaticUpdates, "cell 0 14 3 1");
        this.lblUpdateInterval = new JLabel(TmmResourceBundle.getString("Settings.updatecheck.interval"));
        this.add((Component)this.lblUpdateInterval, "flowx,cell 1 15 2 1");
        this.spUpdateInterval = new JSpinner();
        this.spUpdateInterval.setModel(new SpinnerNumberModel(1, 1, 30, 1));
        this.add((Component)this.spUpdateInterval, "cell 1 15 2 1");
        this.lblUpdateHint = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblUpdateHint, 1);
        this.add((Component)this.lblUpdateHint, "cell 0 16 3 1");
    }

    private void checkChanges() {
        String fontFamily;
        String theme;
        Locale actualLocale2;
        Locale locale;
        LocaleComboBox loc = (LocaleComboBox)this.cbLanguage.getSelectedItem();
        if (loc != null && !(locale = loc.getLocale()).equals(actualLocale2 = Utils.getLocaleFromLanguage(this.settings.getLanguage()))) {
            this.settings.setLanguage(locale.toString());
            TmmResourceBundle.clearCache();
        }
        if (!(theme = this.rdbtnDark.isSelected() ? "Dark" : "Light").equals(this.settings.getTheme())) {
            this.settings.setTheme(theme);
            try {
                TmmUIHelper.setTheme();
                TmmUIHelper.updateUI();
            }
            catch (Exception actualLocale2) {
                // empty catch block
            }
        }
        boolean fontChanged = false;
        Integer fontSize = (Integer)this.cbFontSize.getSelectedItem();
        if (fontSize != null && fontSize.intValue() != this.settings.getFontSize()) {
            this.settings.setFontSize(fontSize);
            fontChanged = true;
        }
        if ((fontFamily = (String)this.cbFontFamily.getSelectedItem()) != null && !fontFamily.equals(this.settings.getFontFamily())) {
            this.settings.setFontFamily(fontFamily);
            fontChanged = true;
        }
        if (fontChanged) {
            Font font = UIManager.getFont("defaultFont");
            Font newFont = new Font(this.settings.getFontFamily(), font.getStyle(), this.settings.getFontSize());
            UIManager.put("defaultFont", newFont);
            TmmUIHelper.updateUI();
        }
        this.settings.setEnableAutomaticUpdate(this.chckbxAutomaticUpdates.isSelected());
        this.settings.setAutomaticUpdateInterval((Integer)this.spUpdateInterval.getValue());
        if (this.chckbxAutomaticUpdates.isSelected()) {
            this.spUpdateInterval.setEnabled(true);
            this.lblUpdateHint.setText("");
        } else {
            this.spUpdateInterval.setEnabled(false);
            this.lblUpdateHint.setText(TmmResourceBundle.getString("Settings.updatecheck.hint"));
        }
    }

    private static class MouseClickEventProxy
    extends MouseAdapter {
        private final AbstractButton button;

        MouseClickEventProxy(AbstractButton button) {
            this.button = button;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.button.doClick();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.button.doClick();
        }
    }
}

