/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.mp4parser.boxes.iso14496.part12.CompositionTimeToSample;
import org.mp4parser.boxes.iso14496.part12.SampleDependencyTypeBox;
import org.mp4parser.boxes.iso14496.part12.SubSampleInformationBox;
import org.mp4parser.boxes.iso14496.part12.TimeToSampleBox;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.muxer.AbstractTrack;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.Track;
import org.mp4parser.muxer.TrackMetaData;

public class ClippedTrack
extends AbstractTrack {
    private Track origTrack;
    private int fromSample;
    private int toSample;

    public ClippedTrack(Track origTrack, long fromSample, long toSample) {
        super("crop(" + origTrack.getName() + ")");
        this.origTrack = origTrack;
        assert (fromSample <= Integer.MAX_VALUE);
        assert (toSample <= Integer.MAX_VALUE);
        this.fromSample = (int)fromSample;
        this.toSample = (int)toSample;
    }

    static List<TimeToSampleBox.Entry> getDecodingTimeEntries(List<TimeToSampleBox.Entry> origSamples, long fromSample, long toSample) {
        if (origSamples != null && !origSamples.isEmpty()) {
            TimeToSampleBox.Entry currentEntry;
            long current = 0L;
            ListIterator<TimeToSampleBox.Entry> e = origSamples.listIterator();
            LinkedList<TimeToSampleBox.Entry> nuList = new LinkedList<TimeToSampleBox.Entry>();
            while ((currentEntry = e.next()).getCount() + current <= fromSample) {
                current += currentEntry.getCount();
            }
            if (currentEntry.getCount() + current >= toSample) {
                nuList.add(new TimeToSampleBox.Entry(toSample - fromSample, currentEntry.getDelta()));
                return nuList;
            }
            nuList.add(new TimeToSampleBox.Entry(currentEntry.getCount() + current - fromSample, currentEntry.getDelta()));
            current += currentEntry.getCount();
            while (e.hasNext() && (currentEntry = e.next()).getCount() + current < toSample) {
                nuList.add(currentEntry);
                current += currentEntry.getCount();
            }
            nuList.add(new TimeToSampleBox.Entry(toSample - current, currentEntry.getDelta()));
            return nuList;
        }
        return null;
    }

    static List<CompositionTimeToSample.Entry> getCompositionTimeEntries(List<CompositionTimeToSample.Entry> origSamples, long fromSample, long toSample) {
        if (origSamples != null && !origSamples.isEmpty()) {
            CompositionTimeToSample.Entry currentEntry;
            long current = 0L;
            ListIterator<CompositionTimeToSample.Entry> e = origSamples.listIterator();
            ArrayList<CompositionTimeToSample.Entry> nuList = new ArrayList<CompositionTimeToSample.Entry>();
            while ((long)(currentEntry = e.next()).getCount() + current <= fromSample) {
                current += (long)currentEntry.getCount();
            }
            if ((long)currentEntry.getCount() + current >= toSample) {
                nuList.add(new CompositionTimeToSample.Entry((int)(toSample - fromSample), currentEntry.getOffset()));
                return nuList;
            }
            nuList.add(new CompositionTimeToSample.Entry((int)((long)currentEntry.getCount() + current - fromSample), currentEntry.getOffset()));
            current += (long)currentEntry.getCount();
            while (e.hasNext() && (long)(currentEntry = e.next()).getCount() + current < toSample) {
                nuList.add(currentEntry);
                current += (long)currentEntry.getCount();
            }
            nuList.add(new CompositionTimeToSample.Entry((int)(toSample - current), currentEntry.getOffset()));
            return nuList;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.origTrack.close();
    }

    @Override
    public List<Sample> getSamples() {
        return this.origTrack.getSamples().subList(this.fromSample, this.toSample);
    }

    @Override
    public List<SampleEntry> getSampleEntries() {
        return this.origTrack.getSampleEntries();
    }

    @Override
    public synchronized long[] getSampleDurations() {
        long[] decodingTimes = new long[this.toSample - this.fromSample];
        System.arraycopy(this.origTrack.getSampleDurations(), this.fromSample, decodingTimes, 0, decodingTimes.length);
        return decodingTimes;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return ClippedTrack.getCompositionTimeEntries(this.origTrack.getCompositionTimeEntries(), this.fromSample, this.toSample);
    }

    @Override
    public synchronized long[] getSyncSamples() {
        if (this.origTrack.getSyncSamples() != null) {
            int i;
            long[] origSyncSamples = this.origTrack.getSyncSamples();
            int j = origSyncSamples.length;
            for (i = 0; i < origSyncSamples.length && origSyncSamples[i] < (long)this.fromSample; ++i) {
            }
            while (j > 0 && (long)this.toSample < origSyncSamples[j - 1]) {
                --j;
            }
            long[] syncSampleArray = new long[j - i];
            System.arraycopy(this.origTrack.getSyncSamples(), i, syncSampleArray, 0, j - i);
            int k = 0;
            while (k < syncSampleArray.length) {
                int n = k++;
                syncSampleArray[n] = syncSampleArray[n] - (long)this.fromSample;
            }
            return syncSampleArray;
        }
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        if (this.origTrack.getSampleDependencies() != null && !this.origTrack.getSampleDependencies().isEmpty()) {
            return this.origTrack.getSampleDependencies().subList(this.fromSample, this.toSample);
        }
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.origTrack.getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.origTrack.getHandler();
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.origTrack.getSubsampleInformationBox();
    }
}

