/*
 * Decompiled with CFR 0.152.
 */
package com.floreysoft.jmte.template;

import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.ModelAdaptor;
import com.floreysoft.jmte.ProcessListener;
import com.floreysoft.jmte.template.Template;
import com.floreysoft.jmte.token.ForEachToken;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class AbstractTemplate
implements Template {
    public static final String ODD_PREFIX = "odd_";
    public static final String EVEN_PREFIX = "even_";
    public static final String LAST_PREFIX = "last_";
    public static final String FIRST_PREFIX = "first_";
    public static final String INDEX_PREFIX = "index_";
    protected Engine engine;
    protected String template;
    protected String sourceName;
    protected Set<String> usedVariables;

    protected void addSpecialVariables(ForEachToken feToken, Map<String, Object> model) {
        this.addSpecialVariables(feToken, model, feToken.getVarName());
        String specialIteratorVariable = this.engine.getModelAdaptor().getSpecialIteratorVariable();
        model.put(specialIteratorVariable, model.get(feToken.getVarName()));
        this.addSpecialVariables(feToken, model, specialIteratorVariable);
    }

    private void addSpecialVariables(ForEachToken feToken, Map<String, Object> model, String suffix) {
        model.put(FIRST_PREFIX + suffix, feToken.isFirst());
        model.put(LAST_PREFIX + suffix, feToken.isLast());
        model.put(EVEN_PREFIX + suffix, feToken.getIndex() % 2 == 0);
        model.put(ODD_PREFIX + suffix, feToken.getIndex() % 2 == 1);
        model.put(INDEX_PREFIX + suffix, feToken.getIndex() + 1);
    }

    @Override
    public abstract String transform(Map<String, Object> var1, Locale var2, ModelAdaptor var3, ProcessListener var4);

    @Override
    public String transform(Map<String, Object> model, Locale locale, ProcessListener processListener) {
        return this.transform(model, locale, this.engine.getModelAdaptor(), processListener);
    }

    @Override
    public String transform(Map<String, Object> model, Locale locale) {
        return this.transform(model, locale, this.engine.getModelAdaptor(), null);
    }

    @Override
    public abstract Set<String> getUsedVariables();
}

