/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp.vp8;

import com.twelvemonkeys.imageio.plugins.webp.vp8.BoolDecoder;
import com.twelvemonkeys.imageio.plugins.webp.vp8.Globals;
import com.twelvemonkeys.imageio.plugins.webp.vp8.IDCT;
import com.twelvemonkeys.imageio.plugins.webp.vp8.MacroBlock;
import com.twelvemonkeys.imageio.plugins.webp.vp8.VP8Frame;
import java.io.IOException;

final class SubBlock {
    private final SubBlock above;
    private int[][] dest;
    private int[][] diff;
    private boolean hasNoZeroToken;
    private final SubBlock left;
    private final MacroBlock macroBlock;
    private int mode;
    private final Plane plane;
    private int[][] predict;
    private int[] tokens = new int[16];

    SubBlock(MacroBlock macroBlock, SubBlock subBlock, SubBlock subBlock2, Plane plane) {
        this.macroBlock = macroBlock;
        this.plane = plane;
        this.above = subBlock;
        this.left = subBlock2;
        this.mode = 0;
        for (int i = 0; i < 16; ++i) {
            this.tokens[i] = 0;
        }
    }

    public static int planeToType(Plane plane, boolean bl) {
        switch (plane) {
            case Y2: {
                return 1;
            }
            case Y1: {
                return bl ? 0 : 3;
            }
            case U: 
            case V: {
                return 2;
            }
        }
        return -1;
    }

    private int DCTextra(BoolDecoder boolDecoder, int[] nArray) throws IOException {
        int n = 0;
        int n2 = 0;
        do {
            n += n + boolDecoder.readBool(nArray[n2]);
        } while (nArray[++n2] > 0);
        return n;
    }

    public void decodeSubBlock(BoolDecoder boolDecoder, int[][][][] nArray, int n, int n2, boolean bl) throws IOException {
        int n3;
        SubBlock subBlock = this;
        int n4 = 0;
        if (bl) {
            n4 = 1;
        }
        int n5 = n;
        int n6 = 0;
        int n7 = 1;
        boolean bl2 = false;
        while (n7 != 11 && n6 + n4 < 16) {
            n7 = boolDecoder.readTree(Globals.vp8CoefTree, nArray[n2][Globals.vp8CoefBands[n6 + n4]][n5], bl2 ? 1 : 0);
            n3 = this.decodeToken(boolDecoder, n7);
            n5 = 0;
            bl2 = false;
            if (n3 == 1 || n3 == -1) {
                n5 = 1;
            } else if (n3 > 1 || n3 < -1) {
                n5 = 2;
            } else if (n3 == 0) {
                bl2 = true;
            }
            int[] nArray2 = subBlock.getTokens();
            if (n7 != 11) {
                nArray2[Globals.vp8defaultZigZag1d[n6 + n4]] = n3;
            }
            ++n6;
        }
        this.hasNoZeroToken = false;
        for (n3 = 0; n3 < 16; ++n3) {
            if (this.tokens[n3] == 0) continue;
            this.hasNoZeroToken = true;
        }
    }

    private int decodeToken(BoolDecoder boolDecoder, int n) throws IOException {
        int n2 = n;
        if (n == 5) {
            n2 = 5 + this.DCTextra(boolDecoder, Globals.Pcat1);
        }
        if (n == 6) {
            n2 = 7 + this.DCTextra(boolDecoder, Globals.Pcat2);
        }
        if (n == 7) {
            n2 = 11 + this.DCTextra(boolDecoder, Globals.Pcat3);
        }
        if (n == 8) {
            n2 = 19 + this.DCTextra(boolDecoder, Globals.Pcat4);
        }
        if (n == 9) {
            n2 = 35 + this.DCTextra(boolDecoder, Globals.Pcat5);
        }
        if (n == 10) {
            n2 = 67 + this.DCTextra(boolDecoder, Globals.Pcat6);
        }
        if (n != 0 && n != 11 && boolDecoder.readBit() > 0) {
            n2 = -n2;
        }
        return n2;
    }

    public void dequantSubBlock(VP8Frame vP8Frame, Integer n) {
        SubBlock subBlock = this;
        int[] nArray = new int[16];
        for (int i = 0; i < 16; ++i) {
            int n2;
            if (this.plane == Plane.U || this.plane == Plane.V) {
                n2 = vP8Frame.getSegmentQuants().getSegQuants()[this.getMacroBlock().getSegmentId()].getUvac_delta_q();
                if (i == 0) {
                    n2 = vP8Frame.getSegmentQuants().getSegQuants()[this.getMacroBlock().getSegmentId()].getUvdc_delta_q();
                }
            } else {
                n2 = vP8Frame.getSegmentQuants().getSegQuants()[this.getMacroBlock().getSegmentId()].getY1ac();
                if (i == 0) {
                    n2 = vP8Frame.getSegmentQuants().getSegQuants()[this.getMacroBlock().getSegmentId()].getY1dc();
                }
            }
            int n3 = subBlock.getTokens()[i];
            nArray[i] = n3 * n2;
        }
        if (n != null) {
            nArray[0] = n;
        }
        int[][] nArray2 = IDCT.idct4x4llm(nArray);
        subBlock.setDiff(nArray2);
    }

    public void drawDebug() {
        if (this.dest != null) {
            this.dest[0][0] = 128;
            this.dest[1][0] = 128;
            this.dest[2][0] = 128;
            this.dest[3][0] = 128;
            this.dest[0][0] = 128;
            this.dest[0][1] = 128;
            this.dest[0][2] = 128;
            this.dest[0][3] = 128;
        }
    }

    public void drawDebugH() {
        if (this.dest != null) {
            this.dest[0][0] = 0;
            this.dest[1][0] = 0;
            this.dest[2][0] = 0;
            this.dest[3][0] = 0;
        }
    }

    public void drawDebugV() {
        if (this.dest != null) {
            this.dest[0][0] = 0;
            this.dest[0][1] = 0;
            this.dest[0][2] = 0;
            this.dest[0][3] = 0;
        }
    }

    public SubBlock getAbove() {
        return this.above;
    }

    public String getDebugString() {
        String string = "";
        string = string + "  " + (Object)((Object)this.plane);
        if (this.getMacroBlock().getYMode() == 4 && this.plane == Plane.Y1) {
            string = string + "\n  " + Globals.getSubBlockModeAsString(this.mode);
        }
        return string;
    }

    public int[][] getDest() {
        if (this.dest != null) {
            return this.dest;
        }
        return new int[4][4];
    }

    public int[][] getDiff() {
        return this.diff;
    }

    public SubBlock getLeft() {
        return this.left;
    }

    public MacroBlock getMacroBlock() {
        return this.macroBlock;
    }

    public int[][] getMacroBlockPredict(int n) {
        if (this.dest != null) {
            return this.dest;
        }
        int n2 = 127;
        if (n == 2) {
            n2 = 129;
        }
        int[][] nArray = new int[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                nArray[j][i] = n2;
            }
        }
        return nArray;
    }

    public int getMode() {
        return this.mode;
    }

    public Plane getPlane() {
        return this.plane;
    }

    public int[][] getPredict() {
        if (this.predict != null) {
            return this.predict;
        }
        return this.getPredict(0, false);
    }

    public int[][] getPredict(int n, boolean bl) {
        if (this.dest != null) {
            return this.dest;
        }
        if (this.predict != null) {
            return this.predict;
        }
        int n2 = 127;
        if ((n == 1 || n == 0 || n == 2 || n == 3 || n == 6 || n == 5 || n == 8) && bl) {
            n2 = 129;
        }
        int[][] nArray = new int[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                nArray[j][i] = n2;
            }
        }
        return nArray;
    }

    int[] getTokens() {
        return this.tokens;
    }

    public boolean hasNoZeroToken() {
        return this.hasNoZeroToken;
    }

    public boolean isDest() {
        return this.dest != null;
    }

    public void predict(VP8Frame vP8Frame) {
        SubBlock subBlock = this;
        SubBlock subBlock2 = vP8Frame.getAboveSubBlock(subBlock, subBlock.getPlane());
        SubBlock subBlock3 = vP8Frame.getLeftSubBlock(subBlock, subBlock.getPlane());
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray[0] = subBlock2.getPredict(subBlock.getMode(), false)[0][3];
        nArray[1] = subBlock2.getPredict(subBlock.getMode(), false)[1][3];
        nArray[2] = subBlock2.getPredict(subBlock.getMode(), false)[2][3];
        nArray[3] = subBlock2.getPredict(subBlock.getMode(), false)[3][3];
        nArray2[0] = subBlock3.getPredict(subBlock.getMode(), true)[3][0];
        nArray2[1] = subBlock3.getPredict(subBlock.getMode(), true)[3][1];
        nArray2[2] = subBlock3.getPredict(subBlock.getMode(), true)[3][2];
        nArray2[3] = subBlock3.getPredict(subBlock.getMode(), true)[3][3];
        SubBlock subBlock4 = vP8Frame.getLeftSubBlock(subBlock2, subBlock.getPlane());
        int n = !subBlock3.isDest() && !subBlock2.isDest() ? subBlock4.getPredict(subBlock.getMode(), false)[3][3] : (!subBlock2.isDest() ? subBlock4.getPredict(subBlock.getMode(), false)[3][3] : subBlock4.getPredict(subBlock.getMode(), true)[3][3]);
        SubBlock subBlock5 = vP8Frame.getAboveRightSubBlock(subBlock, subBlock.plane);
        int[] nArray3 = new int[]{subBlock5.getPredict(subBlock.getMode(), false)[0][3], subBlock5.getPredict(subBlock.getMode(), false)[1][3], subBlock5.getPredict(subBlock.getMode(), false)[2][3], subBlock5.getPredict(subBlock.getMode(), false)[3][3]};
        int[][] nArray4 = new int[4][4];
        switch (subBlock.getMode()) {
            case 0: {
                int n2;
                int n3 = 0;
                for (n2 = 0; n2 < 4; ++n2) {
                    n3 += nArray[n2];
                    n3 += nArray2[n2];
                }
                n3 = n3 + 4 >> 3;
                for (n2 = 0; n2 < 4; ++n2) {
                    for (int i = 0; i < 4; ++i) {
                        nArray4[i][n2] = n3;
                    }
                }
                break;
            }
            case 1: {
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        int n4 = nArray[j] - n + nArray2[i];
                        if (n4 < 0) {
                            n4 = 0;
                        }
                        if (n4 > 255) {
                            n4 = 255;
                        }
                        nArray4[j][i] = n4;
                    }
                }
                break;
            }
            case 2: {
                int[] nArray5 = new int[]{n + 2 * nArray[0] + nArray[1] + 2 >> 2, nArray[0] + 2 * nArray[1] + nArray[2] + 2 >> 2, nArray[1] + 2 * nArray[2] + nArray[3] + 2 >> 2, nArray[2] + 2 * nArray[3] + nArray3[0] + 2 >> 2};
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        nArray4[j][i] = nArray5[j];
                    }
                }
                break;
            }
            case 3: {
                int[] nArray6 = new int[]{n + 2 * nArray2[0] + nArray2[1] + 2 >> 2, nArray2[0] + 2 * nArray2[1] + nArray2[2] + 2 >> 2, nArray2[1] + 2 * nArray2[2] + nArray2[3] + 2 >> 2, nArray2[2] + 2 * nArray2[3] + nArray2[3] + 2 >> 2};
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        nArray4[j][i] = nArray6[i];
                    }
                }
                break;
            }
            case 4: {
                nArray4[0][0] = nArray[0] + nArray[1] * 2 + nArray[2] + 2 >> 2;
                int n5 = nArray[1] + nArray[2] * 2 + nArray[3] + 2 >> 2;
                nArray4[0][1] = n5;
                nArray4[1][0] = n5;
                int n6 = nArray[2] + nArray[3] * 2 + nArray3[0] + 2 >> 2;
                nArray4[0][2] = n6;
                nArray4[1][1] = n6;
                nArray4[2][0] = n6;
                int n7 = nArray[3] + nArray3[0] * 2 + nArray3[1] + 2 >> 2;
                nArray4[0][3] = n7;
                nArray4[1][2] = n7;
                nArray4[2][1] = n7;
                nArray4[3][0] = n7;
                int n8 = nArray3[0] + nArray3[1] * 2 + nArray3[2] + 2 >> 2;
                nArray4[1][3] = n8;
                nArray4[2][2] = n8;
                nArray4[3][1] = n8;
                int n9 = nArray3[1] + nArray3[2] * 2 + nArray3[3] + 2 >> 2;
                nArray4[2][3] = n9;
                nArray4[3][2] = n9;
                nArray4[3][3] = nArray3[2] + nArray3[3] * 2 + nArray3[3] + 2 >> 2;
                break;
            }
            case 5: {
                int[] nArray7 = new int[]{nArray2[3], nArray2[2], nArray2[1], nArray2[0], n, nArray[0], nArray[1], nArray[2], nArray[3]};
                nArray4[0][3] = nArray7[0] + nArray7[1] * 2 + nArray7[2] + 2 >> 2;
                int n10 = nArray7[1] + nArray7[2] * 2 + nArray7[3] + 2 >> 2;
                nArray4[0][2] = n10;
                nArray4[1][3] = n10;
                int n11 = nArray7[2] + nArray7[3] * 2 + nArray7[4] + 2 >> 2;
                nArray4[0][1] = n11;
                nArray4[1][2] = n11;
                nArray4[2][3] = n11;
                int n12 = nArray7[3] + nArray7[4] * 2 + nArray7[5] + 2 >> 2;
                nArray4[0][0] = n12;
                nArray4[1][1] = n12;
                nArray4[2][2] = n12;
                nArray4[3][3] = n12;
                int n13 = nArray7[4] + nArray7[5] * 2 + nArray7[6] + 2 >> 2;
                nArray4[1][0] = n13;
                nArray4[2][1] = n13;
                nArray4[3][2] = n13;
                int n14 = nArray7[5] + nArray7[6] * 2 + nArray7[7] + 2 >> 2;
                nArray4[2][0] = n14;
                nArray4[3][1] = n14;
                nArray4[3][0] = nArray7[6] + nArray7[7] * 2 + nArray7[8] + 2 >> 2;
                break;
            }
            case 6: {
                int[] nArray8 = new int[]{nArray2[3], nArray2[2], nArray2[1], nArray2[0], n, nArray[0], nArray[1], nArray[2], nArray[3]};
                nArray4[0][3] = nArray8[1] + nArray8[2] * 2 + nArray8[3] + 2 >> 2;
                nArray4[0][2] = nArray8[2] + nArray8[3] * 2 + nArray8[4] + 2 >> 2;
                int n15 = nArray8[3] + nArray8[4] * 2 + nArray8[5] + 2 >> 2;
                nArray4[0][1] = n15;
                nArray4[1][3] = n15;
                int n16 = nArray8[4] + nArray8[5] + 1 >> 1;
                nArray4[0][0] = n16;
                nArray4[1][2] = n16;
                int n17 = nArray8[4] + nArray8[5] * 2 + nArray8[6] + 2 >> 2;
                nArray4[1][1] = n17;
                nArray4[2][3] = n17;
                int n18 = nArray8[5] + nArray8[6] + 1 >> 1;
                nArray4[1][0] = n18;
                nArray4[2][2] = n18;
                int n19 = nArray8[5] + nArray8[6] * 2 + nArray8[7] + 2 >> 2;
                nArray4[2][1] = n19;
                nArray4[3][3] = n19;
                int n20 = nArray8[6] + nArray8[7] + 1 >> 1;
                nArray4[2][0] = n20;
                nArray4[3][2] = n20;
                nArray4[3][1] = nArray8[6] + nArray8[7] * 2 + nArray8[8] + 2 >> 2;
                nArray4[3][0] = nArray8[7] + nArray8[8] + 1 >> 1;
                break;
            }
            case 7: {
                nArray4[0][0] = nArray[0] + nArray[1] + 1 >> 1;
                nArray4[0][1] = nArray[0] + nArray[1] * 2 + nArray[2] + 2 >> 2;
                int n21 = nArray[1] + nArray[2] + 1 >> 1;
                nArray4[1][0] = n21;
                nArray4[0][2] = n21;
                int n22 = nArray[1] + nArray[2] * 2 + nArray[3] + 2 >> 2;
                nArray4[0][3] = n22;
                nArray4[1][1] = n22;
                int n23 = nArray[2] + nArray[3] + 1 >> 1;
                nArray4[2][0] = n23;
                nArray4[1][2] = n23;
                int n24 = nArray[2] + nArray[3] * 2 + nArray3[0] + 2 >> 2;
                nArray4[2][1] = n24;
                nArray4[1][3] = n24;
                int n25 = nArray[3] + nArray3[0] + 1 >> 1;
                nArray4[2][2] = n25;
                nArray4[3][0] = n25;
                int n26 = nArray[3] + nArray3[0] * 2 + nArray3[1] + 2 >> 2;
                nArray4[2][3] = n26;
                nArray4[3][1] = n26;
                nArray4[3][2] = nArray3[0] + nArray3[1] * 2 + nArray3[2] + 2 >> 2;
                nArray4[3][3] = nArray3[1] + nArray3[2] * 2 + nArray3[3] + 2 >> 2;
                break;
            }
            case 8: {
                int[] nArray9 = new int[]{nArray2[3], nArray2[2], nArray2[1], nArray2[0], n, nArray[0], nArray[1], nArray[2], nArray[3]};
                nArray4[0][3] = nArray9[0] + nArray9[1] + 1 >> 1;
                nArray4[1][3] = nArray9[0] + nArray9[1] * 2 + nArray9[2] + 2 >> 2;
                int n27 = nArray9[1] + nArray9[2] + 1 >> 1;
                nArray4[2][3] = n27;
                nArray4[0][2] = n27;
                int n28 = nArray9[1] + nArray9[2] * 2 + nArray9[3] + 2 >> 2;
                nArray4[3][3] = n28;
                nArray4[1][2] = n28;
                int n29 = nArray9[2] + nArray9[3] + 1 >> 1;
                nArray4[0][1] = n29;
                nArray4[2][2] = n29;
                int n30 = nArray9[2] + nArray9[3] * 2 + nArray9[4] + 2 >> 2;
                nArray4[1][1] = n30;
                nArray4[3][2] = n30;
                int n31 = nArray9[3] + nArray9[4] + 1 >> 1;
                nArray4[0][0] = n31;
                nArray4[2][1] = n31;
                int n32 = nArray9[3] + nArray9[4] * 2 + nArray9[5] + 2 >> 2;
                nArray4[1][0] = n32;
                nArray4[3][1] = n32;
                nArray4[2][0] = nArray9[4] + nArray9[5] * 2 + nArray9[6] + 2 >> 2;
                nArray4[3][0] = nArray9[5] + nArray9[6] * 2 + nArray9[7] + 2 >> 2;
                break;
            }
            case 9: {
                nArray4[0][0] = nArray2[0] + nArray2[1] + 1 >> 1;
                nArray4[1][0] = nArray2[0] + nArray2[1] * 2 + nArray2[2] + 2 >> 2;
                int n33 = nArray2[1] + nArray2[2] + 1 >> 1;
                nArray4[0][1] = n33;
                nArray4[2][0] = n33;
                int n34 = nArray2[1] + nArray2[2] * 2 + nArray2[3] + 2 >> 2;
                nArray4[1][1] = n34;
                nArray4[3][0] = n34;
                int n35 = nArray2[2] + nArray2[3] + 1 >> 1;
                nArray4[0][2] = n35;
                nArray4[2][1] = n35;
                int n36 = nArray2[2] + nArray2[3] * 2 + nArray2[3] + 2 >> 2;
                nArray4[1][2] = n36;
                nArray4[3][1] = n36;
                int n37 = nArray2[3];
                nArray4[3][3] = n37;
                nArray4[2][3] = n37;
                nArray4[1][3] = n37;
                nArray4[0][3] = n37;
                nArray4[3][2] = n37;
                nArray4[2][2] = n37;
                break;
            }
            default: {
                throw new AssertionError((Object)("TODO mode: " + subBlock.getMode()));
            }
        }
        subBlock.setPredict(nArray4);
    }

    public void reconstruct() {
        SubBlock subBlock = this;
        int[][] nArray = subBlock.getPredict(1, false);
        int[][] nArray2 = new int[4][4];
        int[][] nArray3 = subBlock.getDiff();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int n = nArray3[i][j] + nArray[i][j];
                if (n < 0) {
                    n = 0;
                }
                if (n > 255) {
                    n = 255;
                }
                nArray2[i][j] = n;
            }
        }
        subBlock.setDest(nArray2);
        if (!this.getMacroBlock().isKeepDebugInfo()) {
            subBlock.diff = null;
            subBlock.predict = null;
            subBlock.tokens = null;
        }
    }

    public void setDest(int[][] nArray) {
        this.dest = nArray;
    }

    public void setDiff(int[][] nArray) {
        this.diff = nArray;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public void setPixel(int n, int n2, int n3) {
        if (this.dest == null) {
            this.dest = new int[4][4];
        }
        this.dest[n][n2] = n3;
    }

    public void setPredict(int[][] nArray) {
        this.predict = nArray;
    }

    public String toString() {
        String string = "[";
        for (int i = 0; i < 16; ++i) {
            string = string + this.tokens[i] + " ";
        }
        string = string + "]";
        return string;
    }

    public static enum Plane {
        U,
        V,
        Y1,
        Y2;

    }
}

