/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.rsa;

import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class DigestSignatureSpi
extends SignatureSpi {
    private \u1f6f digest;
    private \u13e3 cipher;
    private \u2d22 algId;

    protected DigestSignatureSpi(\u1f6f \u1f672, \u13e3 \uabb32) {
        this.digest = \u1f672;
        this.cipher = \uabb32;
        this.algId = null;
    }

    protected DigestSignatureSpi(\u01ca \u01cc2, \u1f6f \u1f672, \u13e3 \uabb32) {
        this.digest = \u1f672;
        this.cipher = \uabb32;
        this.algId = new \u2d22(\u01cc2, \u0211.\u1e64);
    }

    @Override
    protected void engineInitVerify(PublicKey object) {
        if (!(object instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(object) + ") is not a RSAPublicKey instance");
        }
        object = \u01a7.\u1e64((RSAPublicKey)object);
        this.digest.\u1e64();
        this.cipher.\u1e64(false, (\u2c9b)object);
    }

    @Override
    protected void engineInitSign(PrivateKey object) {
        if (!(object instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key (" + this.getType(object) + ") is not a RSAPrivateKey instance");
        }
        object = \u01a7.\u1e64((RSAPrivateKey)object);
        this.digest.\u1e64();
        this.cipher.\u1e64(true, (\u2c9b)object);
    }

    private String getType(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName();
    }

    @Override
    protected void engineUpdate(byte by) {
        this.digest.\u1e64(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.digest.\u1e64(byArray, n, n2);
    }

    @Override
    protected byte[] engineSign() {
        byte[] byArray = new byte[this.digest.\u1e64()];
        this.digest.\u1e64(byArray, 0);
        try {
            byArray = this.derEncode(byArray);
            return this.cipher.\u1e64(byArray, 0, byArray.length);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SignatureException("key too small for signature type");
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) {
        byte[] byArray2 = new byte[this.digest.\u1e64()];
        this.digest.\u1e64(byArray2, 0);
        try {
            byArray = this.cipher.\u1e64(byArray, 0, byArray.length);
            byArray2 = this.derEncode(byArray2);
        }
        catch (Exception exception) {
            return false;
        }
        if (byArray.length == byArray2.length) {
            return \u2cb7.\u1e65(byArray, byArray2);
        }
        if (byArray.length == byArray2.length - 2) {
            int n;
            byArray2[1] = (byte)(byArray2[1] - 2);
            byArray2[3] = (byte)(byArray2[3] - 2);
            int n2 = 4 + byArray2[3];
            int n3 = n2 + 2;
            int n4 = 0;
            for (n = 0; n < byArray2.length - n3; ++n) {
                n4 |= byArray[n2 + n] ^ byArray2[n3 + n];
            }
            for (n = 0; n < n2; ++n) {
                n4 |= byArray[n] ^ byArray2[n];
            }
            return n4 == 0;
        }
        \u2cb7.\u1e65(byArray2, byArray2);
        return false;
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String string) {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    private byte[] derEncode(byte[] byArray) {
        if (this.algId == null) {
            return byArray;
        }
        return new \u10c2(this.algId, byArray).\u1e64("DER");
    }
}

