/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.scraper.util.ListUtils;

public class MediaEntityCopyTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaEntityCopyTask.class);
    private static final long CHUNK_SIZE = 0x100000L;
    private final List<? extends MediaEntity> entities;
    private final Path directory;
    private final boolean fileSizeBase10;
    private final String messagePrefix;
    private long totalSize;
    private long timestamp;
    private long bytesDone;
    private MediaEntity currentEntity;
    private int currentEntityIndex;

    public MediaEntityCopyTask(List<? extends MediaEntity> entities, Path directory) {
        super(TmmResourceBundle.getString("task.copying.title"), 100, TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.entities = new ArrayList<MediaEntity>(entities);
        this.directory = directory;
        this.fileSizeBase10 = Settings.getInstance().isFileSizeBase10();
        this.messagePrefix = TmmResourceBundle.getString("task.copying");
    }

    private long calculateSize() {
        long size = 0L;
        for (MediaEntity mediaEntity : this.entities) {
            size += mediaEntity.getTotalFilesize();
        }
        return size;
    }

    @Override
    protected void doInBackground() {
        if (ListUtils.isEmpty(this.entities)) {
            return;
        }
        this.totalSize = this.calculateSize();
        this.timestamp = System.nanoTime();
        if (this.totalSize == 0L) {
            this.setWorkUnits(0);
        }
        try {
            Iterator<? extends MediaEntity> iterator = this.entities.iterator();
            while (iterator.hasNext()) {
                MediaEntity me;
                this.currentEntity = me = iterator.next();
                ++this.currentEntityIndex;
                Path newFolder = this.directory.resolve(Paths.get(me.getDataSource(), new String[0]).relativize(me.getPathNIO()));
                LOGGER.info("Copying files of '{}' to '{}'", (Object)me.getTitle(), (Object)newFolder);
                Files.createDirectories(newFolder, new FileAttribute[0]);
                for (MediaFile mf : me.getMediaFilesRecursive()) {
                    if (this.cancel) break;
                    Path mfPath = mf.getFileAsPath();
                    if (Files.isDirectory(mfPath, new LinkOption[0])) {
                        Path mePath = me.getPathNIO();
                        Stream<Path> stream = Files.walk(mfPath, new FileVisitOption[0]);
                        try {
                            stream.forEach(path -> {
                                if (this.cancel) {
                                    Thread.currentThread().interrupt();
                                }
                                Path relative = mePath.relativize((Path)path);
                                Path targetPath = newFolder.resolve(relative);
                                try {
                                    if (Files.isDirectory(path, new LinkOption[0])) {
                                        Files.createDirectories(targetPath, new FileAttribute[0]);
                                    } else {
                                        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                                        this.copy((Path)path, targetPath);
                                    }
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            });
                            continue;
                        }
                        finally {
                            if (stream != null) {
                                stream.close();
                            }
                            continue;
                        }
                    }
                    Path rel = me.getPathNIO().relativize(mfPath);
                    if (rel.getNameCount() > 1) {
                        Files.createDirectories(newFolder.resolve(rel.getParent()), new FileAttribute[0]);
                    }
                    this.copy(mfPath, newFolder.resolve(rel));
                }
                if (!this.cancel) continue;
                break;
            }
        }
        catch (InterruptedIOException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.error("Could not copy files - '{}'", (Object)e.getMessage());
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MediaEntityCopyTask", "message.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            this.setState(TmmTaskHandle.TaskState.FAILED);
        }
    }

    private void copy(Path source, Path target) throws IOException {
        long totalSize = Files.size(source);
        long position = 0L;
        try (FileChannel inChannel = FileChannel.open(source, StandardOpenOption.READ);
             FileChannel outChannel = FileChannel.open(target, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            while (position < totalSize && !this.cancel) {
                long bytesToTransfer = Math.min(0x100000L, totalSize - position);
                long transferred = inChannel.transferTo(position, bytesToTransfer, outChannel);
                position += transferred;
                this.bytesDone += transferred;
                this.publishStateThrottled();
            }
        }
        if (this.cancel) {
            Files.deleteIfExists(target);
        }
    }

    private void publishStateThrottled() {
        long timestamp2 = System.nanoTime();
        if (timestamp2 - this.timestamp > 250000000L) {
            int progress = 0;
            String taskDescription = this.messagePrefix + " '" + this.currentEntity.getTitle() + "' (" + this.currentEntityIndex + " / " + this.entities.size() + " - ";
            if (this.totalSize > 0L) {
                taskDescription = taskDescription + this.formatBytesForOutput(this.bytesDone) + " / " + this.formatBytesForOutput(this.totalSize) + ")";
                progress = (int)(this.bytesDone * 100L / this.totalSize);
            } else {
                taskDescription = taskDescription + this.formatBytesForOutput(this.bytesDone) + ")";
            }
            this.publishState(taskDescription, progress);
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        Thread.currentThread().interrupt();
    }

    private String formatBytesForOutput(long bytes) {
        double factor;
        double d = factor = this.fileSizeBase10 ? 1000.0 : 1024.0;
        if ((double)bytes < factor) {
            return String.format("%d B", bytes);
        }
        if ((double)bytes < factor * factor) {
            return String.format("%.2f kB", (double)bytes / factor);
        }
        if ((double)bytes < factor * factor * factor) {
            return String.format("%.2f M", (double)bytes / (factor * factor));
        }
        if ((double)bytes < factor * factor * factor * factor) {
            return String.format("%.2f G", (double)bytes / (factor * factor * factor));
        }
        return String.format("%.2f M", (double)bytes / (factor * factor));
    }
}

