/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.index;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.tinymediamanager.library.bluray.index.Index;
import org.tinymediamanager.library.bluray.index.IndexReader;
import org.tinymediamanager.library.bluray.index.IndexWriter;

public class Main {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("Missing input and output arguments");
            Main.usage();
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        if (!string.toLowerCase().endsWith(".xml") && !string.toLowerCase().endsWith(".bdmv") || !string2.toLowerCase().endsWith(".xml") && !string2.toLowerCase().endsWith(".bdmv")) {
            System.out.println("Input and output can only have xml or bdmv extension.");
            Main.usage();
        }
        if (!new File(string).exists()) {
            System.out.println("File " + string + " not found.");
            Main.usage();
        }
        Index index = null;
        FileInputStream fileInputStream = new FileInputStream(string);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(fileInputStream));
        index = string.toLowerCase().endsWith("xml") ? new IndexReader().readXml(dataInputStream) : new IndexReader().readBinary(dataInputStream);
        dataInputStream.close();
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
        if (string2.toLowerCase().endsWith("xml")) {
            new IndexWriter().writeXml(index, dataOutputStream);
        } else {
            new IndexWriter().writeBinary(index, dataOutputStream);
        }
        dataOutputStream.close();
    }

    public static void usage() {
        System.out.println("\n\nThis is a tool to convert index.bdmv to an xml format and back.\n\n");
        System.out.println("Usage:");
        System.out.println("\n" + Main.class.getName() + " Input Output \n");
        System.out.println("where Input can be one of");
        System.out.println("   location of index.bdmv");
        System.out.println("   location of index.xml");
        System.out.println("and the Output can be one of");
        System.out.println("   index.bdmv");
        System.out.println("   index.xml");
        System.exit(1);
    }
}

