/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.subdl;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.bind.DateTypeAdapter;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.subdl.model.SubdlModel;
import org.tinymediamanager.scraper.subdl.model.Type;
import org.tinymediamanager.scraper.subdl.service.SubdlService;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class SubdlController {
    private final Retrofit retrofit;
    private final String apiKey;
    private String userApiKey;

    SubdlController(String apiKey) {
        this.apiKey = apiKey;
        this.retrofit = this.buildRetrofitInstance(TmmHttpClient.newBuilderWithForcedCache(1, TimeUnit.DAYS).build());
    }

    void setUserApiKey(String userApiKey) {
        this.userApiKey = userApiKey;
    }

    String getUserApiKey() {
        return this.userApiKey;
    }

    private GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Integer.class, (json, typeOfT, context) -> {
            try {
                return json.getAsInt();
            }
            catch (NumberFormatException e) {
                return 0;
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        builder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        return builder;
    }

    private Retrofit buildRetrofitInstance(OkHttpClient client) {
        return new Retrofit.Builder().client(client).baseUrl(this.apiKey).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGsonBuilder().create())).build();
    }

    private SubdlService getService() {
        return (SubdlService)this.retrofit.create(SubdlService.class);
    }

    Response<SubdlModel> getResultsForQuery(String query, String language, Type type) throws IOException {
        return this.getService().fetchResults(this.getUserApiKey(), query, type.name().toLowerCase(Locale.ROOT), language).execute();
    }

    Response<SubdlModel> getResultsFromImdbId(String imdbId, String language, Type type, int season, int episode) throws IOException {
        return this.getService().fetchResultswithImdbId(this.getUserApiKey(), imdbId, type.name().toLowerCase(Locale.ROOT), language, season, episode).execute();
    }

    Response<SubdlModel> getResultsFromImdbId(String imdbId, String language, Type type) throws IOException {
        return this.getService().fetchResultswithImdbId(this.getUserApiKey(), imdbId, type.name().toLowerCase(Locale.ROOT), language).execute();
    }

    Response<SubdlModel> getResultsFromTmdbId(int tmdbId, String language, Type type, int season, int episode) throws IOException {
        return this.getService().fetchResultswithTmdbId(this.getUserApiKey(), tmdbId, type.name().toLowerCase(Locale.ROOT), language, season, episode).execute();
    }

    Response<SubdlModel> getResultsFromTmdbId(int tmdbId, String language, Type type) throws IOException {
        return this.getService().fetchResultswithTmdbId(this.getUserApiKey(), tmdbId, type.name().toLowerCase(Locale.ROOT), language).execute();
    }
}

