/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import java.util.Locale;

public final class AdvancedSimilarity {
    private AdvancedSimilarity() {
    }

    public static float compareStrings(String s1, String s2) {
        String b;
        if (s1 == null || s2 == null) {
            return 0.0f;
        }
        String a = AdvancedSimilarity.normalize(s1);
        if (a.equalsIgnoreCase(b = AdvancedSimilarity.normalize(s2))) {
            return 1.0f;
        }
        double jw = AdvancedSimilarity.jaroWinkler(a, b);
        if (Double.isNaN(jw) || jw < 0.0) {
            return 0.0f;
        }
        return (float)jw;
    }

    private static String normalize(String s) {
        if (s == null) {
            return "";
        }
        return s.trim().replaceAll("\\s+", " ").toUpperCase(Locale.ROOT);
    }

    private static double jaroWinkler(String s1, String s2) {
        double jaro = AdvancedSimilarity.jaroDistance(s1, s2);
        double scalingFactor = 0.1;
        int prefix = 0;
        int maxPrefix = 4;
        int lim = Math.min(Math.min(s1.length(), s2.length()), maxPrefix);
        for (int i = 0; i < lim && s1.charAt(i) == s2.charAt(i); ++i) {
            ++prefix;
        }
        return jaro + (double)prefix * 0.1 * (1.0 - jaro);
    }

    private static double jaroDistance(String s1, String s2) {
        int len2;
        if (s1.isEmpty() && s2.isEmpty()) {
            return 1.0;
        }
        if (s1.isEmpty() || s2.isEmpty()) {
            return 0.0;
        }
        int len1 = s1.length();
        int matchDistance = Math.max(len1, len2 = s2.length()) / 2 - 1;
        if (matchDistance < 0) {
            matchDistance = 0;
        }
        boolean[] s1Matches = new boolean[len1];
        boolean[] s2Matches = new boolean[len2];
        int matches = 0;
        block0: for (int i = 0; i < len1; ++i) {
            int start = Math.max(0, i - matchDistance);
            int end = Math.min(len2 - 1, i + matchDistance);
            for (int j = start; j <= end; ++j) {
                if (s2Matches[j] || s1.charAt(i) != s2.charAt(j)) continue;
                s1Matches[i] = true;
                s2Matches[j] = true;
                ++matches;
                continue block0;
            }
        }
        if (matches == 0) {
            return 0.0;
        }
        int t = 0;
        int k = 0;
        for (int i = 0; i < len1; ++i) {
            if (!s1Matches[i]) continue;
            while (!s2Matches[k]) {
                ++k;
            }
            if (s1.charAt(i) != s2.charAt(k)) {
                ++t;
            }
            ++k;
        }
        double transpositions = (double)t / 2.0;
        return ((double)matches / (double)len1 + (double)matches / (double)len2 + ((double)matches - transpositions) / (double)matches) / 3.0;
    }
}

