/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.TmmOsUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.actions.TmmAction;

public class CreateDesktopFileAction
extends TmmAction {
    public CreateDesktopFileAction() {
        this.putValue("Name", TmmResourceBundle.getString("tmm.createdesktopentry"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tmm.createdesktopentry.hint"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        Path desktop;
        Path desktopFile;
        String currentUsersHomeDir = System.getProperty("user.home");
        if (StringUtils.isNotBlank((CharSequence)currentUsersHomeDir) && Files.isWritable((desktopFile = Paths.get(currentUsersHomeDir, ".local", "share", "applications", "tinyMediaManager.desktop").toAbsolutePath()).getParent())) {
            TmmOsUtils.createDesktopFileForLinux(desktopFile.toFile());
        }
        if (Files.isWritable((desktop = Paths.get("tinyMediaManager.desktop", new String[0]).toAbsolutePath()).getParent())) {
            TmmOsUtils.createDesktopFileForLinux(desktop.toFile());
        }
    }
}

