/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import java.awt.FontMetrics;
import java.util.Date;
import javax.swing.ImageIcon;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.DateUtils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.renderer.DateTableCellRenderer;

public class MovieInMovieSetTableFormat
extends TmmTableFormat<Movie> {
    public MovieInMovieSetTableFormat() {
        FontMetrics fontMetrics = this.getFontMetrics();
        TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.title"), "title", Movie::getTitleSortable, String.class);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.year"), "year", MediaEntity::getYear, Movie.class);
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("2000") + this.getCellPadding());
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.dateadded"), "dateadded", MediaEntity::getDateAddedForUi, Date.class);
        col.setColumnResizeable(false);
        col.setCellRenderer(new DateTableCellRenderer());
        try {
            Date date = DateUtils.parseDate("2012-12-12");
            col.setMinWidth(fontMetrics.stringWidth(TmmDateFormat.getDateFormat().format(date)) + this.getCellPadding());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.watched"), "watched", movie -> this.getCheckIcon(movie.isWatched()), ImageIcon.class);
        col.setHeaderIcon(IconManager.WATCHED);
        col.setColumnResizeable(false);
        this.addColumn(col);
    }
}

