/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import javax.swing.JLabel;
import javax.swing.SpinnerNumberModel;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractNumberTvShowUIFilter;

public class TvShowClearArtSizeFilter
extends AbstractNumberTvShowUIFilter {
    public TvShowClearArtSizeFilter() {
        this.spinnerLow.setEditor(this.prepareNumberEditor(this.spinnerLow, "####0 px"));
        this.spinnerHigh.setEditor(this.prepareNumberEditor(this.spinnerHigh, "####0 px"));
    }

    @Override
    protected SpinnerNumberModel getNumberModel() {
        return new SpinnerNumberModel(0, 0, 99999, 1);
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        try {
            boolean foundShow = this.matchInt(tvShow.getArtworkDimension((MediaFileType)MediaFileType.CLEARART).width);
            if (!invert && foundShow) {
                return true;
            }
            if (invert && foundShow) {
                return false;
            }
            for (TvShowEpisode episode : episodes) {
                boolean foundEpisode = this.matchInt(episode.getArtworkDimension((MediaFileType)MediaFileType.CLEARART).width);
                if (invert && !foundEpisode) {
                    return true;
                }
                if (invert || !foundEpisode) continue;
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("filter.clearart.width"));
    }

    @Override
    public String getId() {
        return "tvShowClearArtSize";
    }
}

