/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna.message.header;

import java.util.HashMap;
import java.util.Map;
import org.jupnp.model.message.header.InvalidHeaderException;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.support.model.dlna.message.header.AvailableRangeHeader;
import org.jupnp.support.model.dlna.message.header.AvailableSeekRangeHeader;
import org.jupnp.support.model.dlna.message.header.BufferBytesHeader;
import org.jupnp.support.model.dlna.message.header.BufferInfoHeader;
import org.jupnp.support.model.dlna.message.header.ContentFeaturesHeader;
import org.jupnp.support.model.dlna.message.header.EventTypeHeader;
import org.jupnp.support.model.dlna.message.header.FriendlyNameHeader;
import org.jupnp.support.model.dlna.message.header.GetAvailableSeekRangeHeader;
import org.jupnp.support.model.dlna.message.header.GetContentFeaturesHeader;
import org.jupnp.support.model.dlna.message.header.MaxPrateHeader;
import org.jupnp.support.model.dlna.message.header.PeerManagerHeader;
import org.jupnp.support.model.dlna.message.header.PlaySpeedHeader;
import org.jupnp.support.model.dlna.message.header.PragmaHeader;
import org.jupnp.support.model.dlna.message.header.RealTimeInfoHeader;
import org.jupnp.support.model.dlna.message.header.SCIDHeader;
import org.jupnp.support.model.dlna.message.header.ScmsFlagHeader;
import org.jupnp.support.model.dlna.message.header.SupportedHeader;
import org.jupnp.support.model.dlna.message.header.TimeSeekRangeHeader;
import org.jupnp.support.model.dlna.message.header.TransferModeHeader;
import org.jupnp.support.model.dlna.message.header.WCTHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DLNAHeader<T>
extends UpnpHeader<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DLNAHeader.class);

    public static DLNAHeader<?> newInstance(Type type, String headerValue) {
        DLNAHeader<?> upnpHeader = null;
        for (int i = 0; i < type.getHeaderTypes().length && upnpHeader == null; ++i) {
            Class<DLNAHeader<?>> headerClass = type.getHeaderTypes()[i];
            try {
                LOGGER.trace("Trying to parse '{}' with class: {}", (Object)type, (Object)headerClass.getSimpleName());
                upnpHeader = headerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (headerValue == null) continue;
                upnpHeader.setString(headerValue);
                continue;
            }
            catch (InvalidHeaderException e) {
                LOGGER.trace("Invalid header value for tested type: {} - {}", (Object)headerClass.getSimpleName(), (Object)e.getMessage());
                upnpHeader = null;
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Error instantiating header of type '{}' with value: {}", new Object[]{type, headerValue, e});
            }
        }
        return upnpHeader;
    }

    public static enum Type {
        TimeSeekRange("TimeSeekRange.dlna.org", TimeSeekRangeHeader.class),
        XSeekRange("X-Seek-Range", TimeSeekRangeHeader.class),
        PlaySpeed("PlaySpeed.dlna.org", PlaySpeedHeader.class),
        AvailableSeekRange("availableSeekRange.dlna.org", AvailableSeekRangeHeader.class),
        GetAvailableSeekRange("getAvailableSeekRange.dlna.org", GetAvailableSeekRangeHeader.class),
        GetContentFeatures("getcontentFeatures.dlna.org", GetContentFeaturesHeader.class),
        ContentFeatures("contentFeatures.dlna.org", ContentFeaturesHeader.class),
        TransferMode("transferMode.dlna.org", TransferModeHeader.class),
        FriendlyName("friendlyName.dlna.org", FriendlyNameHeader.class),
        PeerManager("peerManager.dlna.org", PeerManagerHeader.class),
        AvailableRange("Available-Range.dlna.org", AvailableRangeHeader.class),
        SCID("scid.dlna.org", SCIDHeader.class),
        RealTimeInfo("realTimeInfo.dlna.org", RealTimeInfoHeader.class),
        ScmsFlag("scmsFlag.dlna.org", ScmsFlagHeader.class),
        WCT("WCT.dlna.org", WCTHeader.class),
        MaxPrate("Max-Prate.dlna.org", MaxPrateHeader.class),
        EventType("Event-Type.dlna.org", EventTypeHeader.class),
        Supported("Supported", SupportedHeader.class),
        BufferInfo("Buffer-Info.dlna.org", BufferInfoHeader.class),
        RTPH264DeInterleaving("rtp-h264-deint-buf-cap.dlna.org", BufferBytesHeader.class),
        RTPAACDeInterleaving("rtp-aac-deint-buf-cap.dlna.org", BufferBytesHeader.class),
        RTPAMRDeInterleaving("rtp-amr-deint-buf-cap.dlna.org", BufferBytesHeader.class),
        RTPAMRWBPlusDeInterleaving("rtp-amrwbplus-deint-buf-cap.dlna.org", BufferBytesHeader.class),
        PRAGMA("PRAGMA", PragmaHeader.class);

        private static final Map<String, Type> byName;
        private final String httpName;
        private final Class<? extends DLNAHeader<?>>[] headerTypes;

        @SafeVarargs
        private Type(String httpName, Class<? extends DLNAHeader<?>> ... headerClass) {
            this.httpName = httpName;
            this.headerTypes = headerClass;
        }

        public String getHttpName() {
            return this.httpName;
        }

        public Class<? extends DLNAHeader<?>>[] getHeaderTypes() {
            return this.headerTypes;
        }

        public boolean isValidHeaderType(Class<? extends DLNAHeader<?>> clazz) {
            for (Class<DLNAHeader<DLNAHeader<?>>> clazz2 : this.getHeaderTypes()) {
                if (!clazz2.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        }

        public static Type getByHttpName(String httpName) {
            if (httpName == null) {
                return null;
            }
            return byName.get(httpName);
        }

        static {
            byName = new HashMap<String, Type>(){
                private static final long serialVersionUID = 2786641076120338594L;
                {
                    for (Type t : Type.values()) {
                        this.put(t.getHttpName(), t);
                    }
                }
            };
        }
    }
}

