/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.jsonrpc.api.AbstractModel;

public abstract class AbstractCall<T> {
    public static final String RESULT = "result";
    private static final Random RND = new Random(System.currentTimeMillis());
    protected static final ObjectMapper OM = new ObjectMapper();
    public static final String LIMITS = "limits";
    private static final String PARAMS = "params";
    public ObjectNode mRequest = OM.createObjectNode();
    protected T mResult = null;
    protected ArrayList<T> mResults = null;
    private final String mId;

    public abstract String getName();

    protected abstract boolean returnsList();

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    protected AbstractCall() {
        ObjectNode objectNode = this.mRequest;
        this.mId = String.valueOf(RND.nextLong());
        objectNode.put("jsonrpc", "2.0");
        objectNode.put("id", this.mId);
        objectNode.put("method", this.getName());
    }

    public ObjectNode getRequest() {
        return this.mRequest;
    }

    public void setResponse(JsonNode jsonNode) {
        if (this.returnsList()) {
            this.mResults = this.parseMany(jsonNode.findValue(RESULT));
        } else {
            this.mResult = this.parseOne(jsonNode.findValue(RESULT));
        }
    }

    public void copyResponse(AbstractCall<?> abstractCall) {
        if (this.returnsList()) {
            this.mResults = abstractCall.getResults();
        } else {
            this.mResult = abstractCall.getResult();
        }
    }

    public T getResult() {
        if (this.returnsList()) {
            return this.mResults.get(0);
        }
        return this.mResult;
    }

    public ArrayList<T> getResults() {
        if (!this.returnsList()) {
            ArrayList<T> arrayList = new ArrayList<T>(1);
            arrayList.add(this.mResult);
            return arrayList;
        }
        return this.mResults;
    }

    public String getId() {
        return this.mId;
    }

    protected JsonNode parseResult(JsonNode jsonNode) {
        return jsonNode.findValue(RESULT);
    }

    protected ArrayNode parseResults(JsonNode jsonNode, String string) {
        if (jsonNode.findValue(string) instanceof NullNode) {
            return null;
        }
        return (ArrayNode)jsonNode.findValue(string);
    }

    protected T parseOne(JsonNode jsonNode) {
        return null;
    }

    protected ArrayList<T> parseMany(JsonNode jsonNode) {
        return null;
    }

    protected void addParameter(String string, String string2) {
        if (string2 != null) {
            this.getParameters().put(string, string2);
        }
    }

    protected void addParameter(String string, Integer n) {
        if (n != null) {
            this.getParameters().put(string, n);
        }
    }

    protected void addParameter(String string, Boolean bl) {
        if (bl != null) {
            this.getParameters().put(string, bl);
        }
    }

    protected void addParameter(String string, Double d) {
        if (d != null) {
            this.getParameters().put(string, d);
        }
    }

    protected void addParameter(String string, AbstractModel abstractModel) {
        if (abstractModel != null) {
            this.getParameters().put(string, abstractModel.toJsonNode());
        }
    }

    protected void addParameter(String string, AbstractModel ... abstractModelArray) {
        if (abstractModelArray != null) {
            for (AbstractModel abstractModel : abstractModelArray) {
                this.getParameters().put(string, abstractModel.toJsonNode());
            }
        }
    }

    protected void addParameter(String string, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        ArrayNode arrayNode = OM.createArrayNode();
        for (String string2 : stringArray) {
            arrayNode.add(string2);
        }
        this.getParameters().put(string, (JsonNode)arrayNode);
    }

    protected void addParameter(String string, HashMap<String, String> hashMap) {
        if (hashMap == null || hashMap.size() == 0) {
            return;
        }
        ObjectNode objectNode = OM.createObjectNode();
        for (String string2 : hashMap.values()) {
            objectNode.put(string2, hashMap.get(string2));
        }
        this.getParameters().put(string, (JsonNode)objectNode);
    }

    private ObjectNode getParameters() {
        ObjectNode objectNode = this.mRequest;
        if (objectNode.has(PARAMS)) {
            return (ObjectNode)objectNode.get(PARAMS);
        }
        ObjectNode objectNode2 = OM.createObjectNode();
        objectNode.put(PARAMS, (JsonNode)objectNode2);
        return objectNode2;
    }
}

