/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.engine.EvolutionResult;
import io.jenetics.stat.DoubleMomentStatistics;
import io.jenetics.stat.DoubleMoments;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.DoubleConsumer;
import java.util.function.Predicate;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;

final class FitnessConvergenceLimit<N extends Number>
implements Predicate<EvolutionResult<?, N>> {
    private final int _shortFilterSize;
    private final int _longFilterSize;
    private final Buffer _buffer;
    private final BiPredicate<DoubleMoments, DoubleMoments> _proceed;

    FitnessConvergenceLimit(int shortFilterSize, int longFilterSize, BiPredicate<DoubleMoments, DoubleMoments> proceed) {
        if (shortFilterSize < 1) {
            throw new IllegalArgumentException(String.format("The short filter size must be greater than one: %d", shortFilterSize));
        }
        if (longFilterSize < 2) {
            throw new IllegalArgumentException(String.format("The long filter size must be greater than two: %d", shortFilterSize));
        }
        if (shortFilterSize >= longFilterSize) {
            throw new IllegalArgumentException(String.format("The long filter size must be greater than the short filter size: %d <= %d", longFilterSize, shortFilterSize));
        }
        this._shortFilterSize = shortFilterSize;
        this._longFilterSize = longFilterSize;
        this._buffer = new Buffer(longFilterSize);
        this._proceed = Objects.requireNonNull(proceed);
    }

    @Override
    public boolean test(EvolutionResult<?, N> result) {
        Number fitness = (Number)result.getBestFitness();
        if (fitness != null) {
            this._buffer.accept(fitness.doubleValue());
        }
        return !this._buffer.isFull() || this._proceed.test(this._buffer.doubleMoments(this._shortFilterSize), this._buffer.doubleMoments(this._longFilterSize));
    }

    static final class Buffer
    implements DoubleConsumer {
        private final double[] _buffer;
        private int _pos;
        private int _length;
        private long _samples;

        Buffer(int capacity) {
            if (capacity < 1) {
                throw new IllegalArgumentException(String.format("Buffer capacity must be greater than one: %d", capacity));
            }
            this._buffer = new double[capacity];
        }

        @Override
        public void accept(double value) {
            this._buffer[this._pos] = value;
            this._pos = (this._pos + 1) % this._buffer.length;
            this._length = Math.min(this._length + 1, this._buffer.length);
            ++this._samples;
        }

        public int capacity() {
            return this._buffer.length;
        }

        public int length() {
            return this._length;
        }

        public long samples() {
            return this._samples;
        }

        public boolean isFull() {
            return this._length == this._buffer.length;
        }

        public DoubleStream stream(int windowSize) {
            int length = Math.min(windowSize, this._length);
            return IntStream.range(0, length).map(i -> (this._pos + this._buffer.length - length + i) % this._buffer.length).mapToDouble(i -> this._buffer[i]);
        }

        public DoubleStream stream() {
            return this.stream(this._length);
        }

        public DoubleMoments doubleMoments(int windowSize) {
            return DoubleMoments.of(this.stream(windowSize).collect(DoubleMomentStatistics::new, DoubleMomentStatistics::accept, DoubleMomentStatistics::combine));
        }

        public DoubleMoments doubleMoments() {
            return this.doubleMoments(this._length);
        }
    }
}

