/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoClientException;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.bulk.DeleteRequest;
import com.mongodb.internal.bulk.UpdateRequest;
import com.mongodb.internal.bulk.WriteRequest;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.operation.ServerVersionHelper;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import java.util.List;
import org.bson.BsonDocument;

final class OperationHelper {
    public static final Logger LOGGER = Loggers.getLogger("operation");

    static void validateCollationAndWriteConcern(@Nullable Collation collation, WriteConcern writeConcern) {
        if (collation != null && !writeConcern.isAcknowledged()) {
            throw new MongoClientException("Specifying collation with an unacknowledged WriteConcern is not supported");
        }
    }

    private static void validateArrayFilters(WriteConcern writeConcern) {
        if (!writeConcern.isAcknowledged()) {
            throw new MongoClientException("Specifying array filters with an unacknowledged WriteConcern is not supported");
        }
    }

    private static void validateWriteRequestHint(ConnectionDescription connectionDescription, WriteConcern writeConcern, WriteRequest request) {
        if (!writeConcern.isAcknowledged()) {
            if (request instanceof UpdateRequest && ServerVersionHelper.serverIsLessThanVersionFourDotTwo(connectionDescription)) {
                throw new IllegalArgumentException(String.format("Hint not supported by wire version: %s", connectionDescription.getMaxWireVersion()));
            }
            if (request instanceof DeleteRequest && ServerVersionHelper.serverIsLessThanVersionFourDotFour(connectionDescription)) {
                throw new IllegalArgumentException(String.format("Hint not supported by wire version: %s", connectionDescription.getMaxWireVersion()));
            }
        }
    }

    static void validateHintForFindAndModify(ConnectionDescription connectionDescription, WriteConcern writeConcern) {
        if (ServerVersionHelper.serverIsLessThanVersionFourDotTwo(connectionDescription)) {
            throw new IllegalArgumentException(String.format("Hint not supported by wire version: %s", connectionDescription.getMaxWireVersion()));
        }
        if (!writeConcern.isAcknowledged() && ServerVersionHelper.serverIsLessThanVersionFourDotFour(connectionDescription)) {
            throw new IllegalArgumentException(String.format("Hint not supported by wire version: %s", connectionDescription.getMaxWireVersion()));
        }
    }

    private static void validateWriteRequestCollations(List<? extends WriteRequest> requests, WriteConcern writeConcern) {
        Collation collation = null;
        for (WriteRequest writeRequest : requests) {
            if (writeRequest instanceof UpdateRequest) {
                collation = ((UpdateRequest)writeRequest).getCollation();
            } else if (writeRequest instanceof DeleteRequest) {
                collation = ((DeleteRequest)writeRequest).getCollation();
            }
            if (collation == null) continue;
            break;
        }
        OperationHelper.validateCollationAndWriteConcern(collation, writeConcern);
    }

    private static void validateUpdateRequestArrayFilters(List<? extends WriteRequest> requests, WriteConcern writeConcern) {
        for (WriteRequest writeRequest : requests) {
            List<BsonDocument> arrayFilters = null;
            if (writeRequest instanceof UpdateRequest) {
                arrayFilters = ((UpdateRequest)writeRequest).getArrayFilters();
            }
            if (arrayFilters == null) continue;
            OperationHelper.validateArrayFilters(writeConcern);
            break;
        }
    }

    private static void validateWriteRequestHints(ConnectionDescription connectionDescription, List<? extends WriteRequest> requests, WriteConcern writeConcern) {
        for (WriteRequest writeRequest : requests) {
            BsonDocument hint = null;
            String hintString = null;
            if (writeRequest instanceof UpdateRequest) {
                hint = ((UpdateRequest)writeRequest).getHint();
                hintString = ((UpdateRequest)writeRequest).getHintString();
            } else if (writeRequest instanceof DeleteRequest) {
                hint = ((DeleteRequest)writeRequest).getHint();
                hintString = ((DeleteRequest)writeRequest).getHintString();
            }
            if (hint == null && hintString == null) continue;
            OperationHelper.validateWriteRequestHint(connectionDescription, writeConcern, writeRequest);
            break;
        }
    }

    static void validateWriteRequests(ConnectionDescription connectionDescription, Boolean bypassDocumentValidation, List<? extends WriteRequest> requests, WriteConcern writeConcern) {
        OperationHelper.checkBypassDocumentValidationIsSupported(bypassDocumentValidation, writeConcern);
        OperationHelper.validateWriteRequestCollations(requests, writeConcern);
        OperationHelper.validateUpdateRequestArrayFilters(requests, writeConcern);
        OperationHelper.validateWriteRequestHints(connectionDescription, requests, writeConcern);
    }

    static <R> boolean validateWriteRequestsAndCompleteIfInvalid(ConnectionDescription connectionDescription, Boolean bypassDocumentValidation, List<? extends WriteRequest> requests, WriteConcern writeConcern, SingleResultCallback<R> callback) {
        try {
            OperationHelper.validateWriteRequests(connectionDescription, bypassDocumentValidation, requests, writeConcern);
            return false;
        }
        catch (Throwable validationT) {
            callback.onResult(null, validationT);
            return true;
        }
    }

    private static void checkBypassDocumentValidationIsSupported(@Nullable Boolean bypassDocumentValidation, WriteConcern writeConcern) {
        if (bypassDocumentValidation != null && !writeConcern.isAcknowledged()) {
            throw new MongoClientException("Specifying bypassDocumentValidation with an unacknowledged WriteConcern is not supported");
        }
    }

    static boolean isRetryableWrite(boolean retryWrites, WriteConcern writeConcern, ConnectionDescription connectionDescription, SessionContext sessionContext) {
        if (!retryWrites) {
            return false;
        }
        if (!writeConcern.isAcknowledged()) {
            LOGGER.debug("retryWrites set to true but the writeConcern is unacknowledged.");
            return false;
        }
        if (sessionContext.hasActiveTransaction()) {
            LOGGER.debug("retryWrites set to true but in an active transaction.");
            return false;
        }
        return OperationHelper.canRetryWrite(connectionDescription, sessionContext);
    }

    static boolean canRetryWrite(ConnectionDescription connectionDescription, SessionContext sessionContext) {
        if (connectionDescription.getLogicalSessionTimeoutMinutes() == null) {
            LOGGER.debug("retryWrites set to true but the server does not support sessions.");
            return false;
        }
        if (connectionDescription.getServerType().equals((Object)ServerType.STANDALONE)) {
            LOGGER.debug("retryWrites set to true but the server is a standalone server.");
            return false;
        }
        return true;
    }

    static boolean canRetryRead(ServerDescription serverDescription, SessionContext sessionContext) {
        if (sessionContext.hasActiveTransaction()) {
            LOGGER.debug("retryReads set to true but in an active transaction.");
            return false;
        }
        return true;
    }

    private OperationHelper() {
    }

    public static final class ResourceSupplierInternalException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        ResourceSupplierInternalException(Throwable cause) {
            super(Assertions.assertNotNull(cause));
        }

        @Override
        @NonNull
        public Throwable getCause() {
            return Assertions.assertNotNull(super.getCause());
        }
    }
}

