/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.integration.api.hotspot.dto;

import com.ubnt.net.Dto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.lang.Nullable;

@Schema(name="Hotspot voucher creation request")
public final class IntegrationVoucherCreateDto
implements Dto {
    @Schema(description="Number of vouchers to generate", defaultValue="1")
    @Nullable
    @Min(value=1L)
    @Max(value=1000L)
    private final @Min(value=1L) @Max(value=1000L) Integer count;
    @Schema(description="Voucher note, duplicated across all generated vouchers")
    @NotBlank
    private final String name;
    @Schema(description="(Optional) limit for how many different guests can use the same voucher to authorize network access", example="1")
    @Nullable
    @Min(value=1L)
    private final @Min(value=1L) Long authorizedGuestLimit;
    @Schema(description="How long (in minutes) the voucher will provide access to the network since authorization of the first guest.\nSubsequently connected guests, if allowed, will share the same expiration time.")
    @NotNull
    @Min(value=1L)
    @Max(value=1000000L)
    private final @NotNull @Min(value=1L) @Max(value=1000000L) Long timeLimitMinutes;
    @Schema(description="(Optional) data usage limit in megabytes")
    @Nullable
    @Min(value=1L)
    @Max(value=0x100000L)
    private final @Min(value=1L) @Max(value=0x100000L) Long dataUsageLimitMBytes;
    @Schema(description="(Optional) download rate limit in kilobits per second")
    @Nullable
    @Min(value=2L)
    @Max(value=100000L)
    private final @Min(value=2L) @Max(value=100000L) Long rxRateLimitKbps;
    @Schema(description="(Optional) upload rate limit in kilobits per second")
    @Nullable
    @Min(value=2L)
    @Max(value=100000L)
    private final @Min(value=2L) @Max(value=100000L) Long txRateLimitKbps;

    @ConstructorProperties(value={"count", "name", "authorizedGuestLimit", "timeLimitMinutes", "dataUsageLimitMBytes", "rxRateLimitKbps", "txRateLimitKbps"})
    @Generated
    public IntegrationVoucherCreateDto(@Nullable Integer n2, String string, @Nullable Long l2, Long l3, @Nullable Long l4, @Nullable Long l5, @Nullable Long l6) {
        this.count = n2;
        this.name = string;
        this.authorizedGuestLimit = l2;
        this.timeLimitMinutes = l3;
        this.dataUsageLimitMBytes = l4;
        this.rxRateLimitKbps = l5;
        this.txRateLimitKbps = l6;
    }

    @Nullable
    @Generated
    public Integer getCount() {
        return this.count;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Nullable
    @Generated
    public Long getAuthorizedGuestLimit() {
        return this.authorizedGuestLimit;
    }

    @Generated
    public Long getTimeLimitMinutes() {
        return this.timeLimitMinutes;
    }

    @Nullable
    @Generated
    public Long getDataUsageLimitMBytes() {
        return this.dataUsageLimitMBytes;
    }

    @Nullable
    @Generated
    public Long getRxRateLimitKbps() {
        return this.rxRateLimitKbps;
    }

    @Nullable
    @Generated
    public Long getTxRateLimitKbps() {
        return this.txRateLimitKbps;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntegrationVoucherCreateDto)) {
            return false;
        }
        IntegrationVoucherCreateDto integrationVoucherCreateDto = (IntegrationVoucherCreateDto)object;
        Integer n2 = this.getCount();
        Integer n3 = integrationVoucherCreateDto.getCount();
        if (n2 == null ? n3 != null : !((Object)n2).equals(n3)) {
            return false;
        }
        Long l2 = this.getAuthorizedGuestLimit();
        Long l3 = integrationVoucherCreateDto.getAuthorizedGuestLimit();
        if (l2 == null ? l3 != null : !((Object)l2).equals(l3)) {
            return false;
        }
        Long l4 = this.getTimeLimitMinutes();
        Long l5 = integrationVoucherCreateDto.getTimeLimitMinutes();
        if (l4 == null ? l5 != null : !((Object)l4).equals(l5)) {
            return false;
        }
        Long l6 = this.getDataUsageLimitMBytes();
        Long l7 = integrationVoucherCreateDto.getDataUsageLimitMBytes();
        if (l6 == null ? l7 != null : !((Object)l6).equals(l7)) {
            return false;
        }
        Long l8 = this.getRxRateLimitKbps();
        Long l9 = integrationVoucherCreateDto.getRxRateLimitKbps();
        if (l8 == null ? l9 != null : !((Object)l8).equals(l9)) {
            return false;
        }
        Long l10 = this.getTxRateLimitKbps();
        Long l11 = integrationVoucherCreateDto.getTxRateLimitKbps();
        if (l10 == null ? l11 != null : !((Object)l10).equals(l11)) {
            return false;
        }
        String string = this.getName();
        String string2 = integrationVoucherCreateDto.getName();
        return !(string == null ? string2 != null : !string.equals(string2));
    }

    @Generated
    public int hashCode() {
        int n2 = 1;
        Integer n3 = this.getCount();
        n2 = n2 * 59 + (n3 == null ? 43 : ((Object)n3).hashCode());
        Long l2 = this.getAuthorizedGuestLimit();
        n2 = n2 * 59 + (l2 == null ? 43 : ((Object)l2).hashCode());
        Long l3 = this.getTimeLimitMinutes();
        n2 = n2 * 59 + (l3 == null ? 43 : ((Object)l3).hashCode());
        Long l4 = this.getDataUsageLimitMBytes();
        n2 = n2 * 59 + (l4 == null ? 43 : ((Object)l4).hashCode());
        Long l5 = this.getRxRateLimitKbps();
        n2 = n2 * 59 + (l5 == null ? 43 : ((Object)l5).hashCode());
        Long l6 = this.getTxRateLimitKbps();
        n2 = n2 * 59 + (l6 == null ? 43 : ((Object)l6).hashCode());
        String string = this.getName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        return n2;
    }

    @Generated
    public String toString() {
        return "IntegrationVoucherCreateDto(count=" + this.getCount() + ", name=" + this.getName() + ", authorizedGuestLimit=" + this.getAuthorizedGuestLimit() + ", timeLimitMinutes=" + this.getTimeLimitMinutes() + ", dataUsageLimitMBytes=" + this.getDataUsageLimitMBytes() + ", rxRateLimitKbps=" + this.getRxRateLimitKbps() + ", txRateLimitKbps=" + this.getTxRateLimitKbps() + ")";
    }
}

