/*
 * Decompiled with CFR 0.152.
 */
package org.ahocorasick.trie;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import org.ahocorasick.interval.IntervalTree;
import org.ahocorasick.interval.Intervalable;
import org.ahocorasick.trie.Payload;
import org.ahocorasick.trie.PayloadEmit;
import org.ahocorasick.trie.PayloadFragmentToken;
import org.ahocorasick.trie.PayloadMatchToken;
import org.ahocorasick.trie.PayloadState;
import org.ahocorasick.trie.PayloadToken;
import org.ahocorasick.trie.TrieConfig;
import org.ahocorasick.trie.handler.DefaultPayloadEmitHandler;
import org.ahocorasick.trie.handler.PayloadEmitHandler;
import org.ahocorasick.trie.handler.StatefulPayloadEmitHandler;

public class PayloadTrie<T> {
    private final TrieConfig trieConfig;
    private final PayloadState<T> rootState;

    protected PayloadTrie(TrieConfig trieConfig) {
        this.trieConfig = trieConfig;
        this.rootState = new PayloadState();
    }

    private void addKeyword(String keyword, T emit) {
        if (keyword.isEmpty()) {
            return;
        }
        this.addState(keyword).addEmit(new Payload<T>(keyword, emit));
    }

    private void addKeyword(String keyword) {
        if (keyword.isEmpty()) {
            return;
        }
        this.addState(keyword).addEmit(new Payload<Object>(keyword, null));
    }

    private PayloadState<T> addState(String keyword) {
        PayloadState<T> state = this.getRootState();
        char[] cArray = keyword.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character character = Character.valueOf(cArray[i]);
            Character adjustedChar = Character.valueOf(this.isCaseInsensitive() ? Character.toLowerCase(character.charValue()) : character.charValue());
            state = state.addState(adjustedChar);
        }
        return state;
    }

    public Collection<PayloadToken<T>> tokenize(String text) {
        LinkedList<PayloadToken<T>> tokens = new LinkedList<PayloadToken<T>>();
        Collection<PayloadEmit<T>> collectedEmits = this.parseText(text);
        int lastCollectedPosition = -1;
        for (PayloadEmit<T> emit : collectedEmits) {
            if (emit.getStart() - lastCollectedPosition > 1) {
                tokens.add(this.createFragment(emit, text, lastCollectedPosition));
            }
            tokens.add(this.createMatch(emit, text));
            lastCollectedPosition = emit.getEnd();
        }
        if (text.length() - lastCollectedPosition > 1) {
            tokens.add(this.createFragment(null, text, lastCollectedPosition));
        }
        return tokens;
    }

    private PayloadToken<T> createFragment(PayloadEmit<T> emit, String text, int lastCollectedPosition) {
        return new PayloadFragmentToken(text.substring(lastCollectedPosition + 1, emit == null ? text.length() : emit.getStart()));
    }

    private PayloadToken<T> createMatch(PayloadEmit<T> emit, String text) {
        return new PayloadMatchToken<T>(text.substring(emit.getStart(), emit.getEnd() + 1), emit);
    }

    public Collection<PayloadEmit<T>> parseText(CharSequence text) {
        return this.parseText(text, new DefaultPayloadEmitHandler());
    }

    public Collection<PayloadEmit<T>> parseText(CharSequence text, StatefulPayloadEmitHandler<T> emitHandler) {
        this.parseText(text, (PayloadEmitHandler<T>)emitHandler);
        List<Intervalable> collectedEmits = emitHandler.getEmits();
        if (!this.trieConfig.isAllowOverlaps()) {
            IntervalTree intervalTree = new IntervalTree(collectedEmits);
            intervalTree.removeOverlaps(collectedEmits);
        }
        return collectedEmits;
    }

    public boolean containsMatch(CharSequence text) {
        return this.firstMatch(text) != null;
    }

    public void parseText(CharSequence text, PayloadEmitHandler<T> emitHandler) {
        PayloadState<T> currentState = this.getRootState();
        for (int position = 0; position < text.length(); ++position) {
            Collection<Payload<T>> payloads;
            char character = text.charAt(position);
            if (this.trieConfig.isCaseInsensitive()) {
                character = Character.toLowerCase(character);
            }
            if (!this.processEmits(text, position, payloads = (currentState = this.getState(currentState, Character.valueOf(character))).emit(), emitHandler) || !this.trieConfig.isStopOnHit()) continue;
            return;
        }
    }

    public PayloadEmit<T> firstMatch(CharSequence text) {
        if (!this.trieConfig.isAllowOverlaps()) {
            Collection<PayloadEmit<T>> parseText = this.parseText(text);
            if (parseText != null && !parseText.isEmpty()) {
                return parseText.iterator().next();
            }
        } else {
            PayloadState<T> currentState = this.getRootState();
            for (int position = 0; position < text.length(); ++position) {
                Collection<Payload<T>> payloads;
                char character = text.charAt(position);
                if (this.trieConfig.isCaseInsensitive()) {
                    character = Character.toLowerCase(character);
                }
                if ((payloads = (currentState = this.getState(currentState, Character.valueOf(character))).emit()) == null || payloads.isEmpty()) continue;
                for (Payload<T> payload : payloads) {
                    PayloadEmit<T> emit = new PayloadEmit<T>(position - payload.getKeyword().length() + 1, position, payload.getKeyword(), payload.getData());
                    if (this.trieConfig.isOnlyWholeWords()) {
                        if (this.isPartialMatch(text, emit)) continue;
                        return emit;
                    }
                    return emit;
                }
            }
        }
        return null;
    }

    private boolean isPartialMatch(CharSequence searchText, PayloadEmit<T> emit) {
        return emit.getStart() != 0 && Character.isAlphabetic(searchText.charAt(emit.getStart() - 1)) || emit.getEnd() + 1 != searchText.length() && Character.isAlphabetic(searchText.charAt(emit.getEnd() + 1));
    }

    private boolean isPartialMatchWhiteSpaceSeparated(CharSequence searchText, PayloadEmit<T> emit) {
        long size = searchText.length();
        return emit.getStart() != 0 && !Character.isWhitespace(searchText.charAt(emit.getStart() - 1)) || (long)(emit.getEnd() + 1) != size && !Character.isWhitespace(searchText.charAt(emit.getEnd() + 1));
    }

    private PayloadState<T> getState(PayloadState<T> currentState, Character character) {
        PayloadState<T> newCurrentState = currentState.nextState(character);
        while (newCurrentState == null) {
            currentState = currentState.failure();
            newCurrentState = currentState.nextState(character);
        }
        return newCurrentState;
    }

    private void constructFailureStates() {
        LinkedBlockingDeque queue = new LinkedBlockingDeque();
        PayloadState<T> startState = this.getRootState();
        for (PayloadState<T> depthOneState : startState.getStates()) {
            depthOneState.setFailure(startState);
            queue.add(depthOneState);
        }
        while (!queue.isEmpty()) {
            PayloadState currentState = (PayloadState)queue.remove();
            for (Character transition : currentState.getTransitions()) {
                PayloadState targetState = currentState.nextState(transition);
                queue.add(targetState);
                PayloadState traceFailureState = currentState.failure();
                while (traceFailureState.nextState(transition) == null) {
                    traceFailureState = traceFailureState.failure();
                }
                PayloadState newFailureState = traceFailureState.nextState(transition);
                targetState.setFailure(newFailureState);
                targetState.addEmit(newFailureState.emit());
            }
        }
    }

    private boolean processEmits(CharSequence text, int position, Collection<Payload<T>> payloads, PayloadEmitHandler<T> emitHandler) {
        boolean emitted = false;
        for (Payload<T> payload : payloads) {
            PayloadEmit<T> payloadEmit = new PayloadEmit<T>(position - payload.getKeyword().length() + 1, position, payload.getKeyword(), payload.getData());
            if (this.trieConfig.isOnlyWholeWords() && this.isPartialMatch(text, payloadEmit) || this.trieConfig.isOnlyWholeWordsWhiteSpaceSeparated() && this.isPartialMatchWhiteSpaceSeparated(text, payloadEmit) || !(emitted = emitHandler.emit(payloadEmit) || emitted) || !this.trieConfig.isStopOnHit()) continue;
            break;
        }
        return emitted;
    }

    private boolean isCaseInsensitive() {
        return this.trieConfig.isCaseInsensitive();
    }

    private PayloadState<T> getRootState() {
        return this.rootState;
    }

    public static <T> PayloadTrieBuilder<T> builder() {
        return new PayloadTrieBuilder();
    }

    public static class PayloadTrieBuilder<T> {
        private final TrieConfig trieConfig = new TrieConfig();
        private final PayloadTrie<T> trie = new PayloadTrie(this.trieConfig);

        private PayloadTrieBuilder() {
        }

        public PayloadTrieBuilder<T> ignoreCase() {
            this.trieConfig.setCaseInsensitive(true);
            return this;
        }

        public PayloadTrieBuilder<T> ignoreOverlaps() {
            this.trieConfig.setAllowOverlaps(false);
            return this;
        }

        public PayloadTrieBuilder<T> addKeyword(String keyword) {
            ((PayloadTrie)this.trie).addKeyword(keyword);
            return this;
        }

        public PayloadTrieBuilder<T> addKeyword(String keyword, T payload) {
            ((PayloadTrie)this.trie).addKeyword(keyword, payload);
            return this;
        }

        public PayloadTrieBuilder<T> addKeywords(Collection<Payload<T>> keywords) {
            for (Payload<T> payload : keywords) {
                ((PayloadTrie)this.trie).addKeyword(payload.getKeyword(), payload.getData());
            }
            return this;
        }

        public PayloadTrieBuilder<T> onlyWholeWords() {
            this.trieConfig.setOnlyWholeWords(true);
            return this;
        }

        public PayloadTrieBuilder<T> onlyWholeWordsWhiteSpaceSeparated() {
            this.trieConfig.setOnlyWholeWordsWhiteSpaceSeparated(true);
            return this;
        }

        public PayloadTrieBuilder<T> stopOnHit() {
            ((PayloadTrie)this.trie).trieConfig.setStopOnHit(true);
            return this;
        }

        public PayloadTrie<T> build() {
            ((PayloadTrie)this.trie).constructFailureStates();
            return this.trie;
        }

        @Deprecated
        public PayloadTrieBuilder<T> caseInsensitive() {
            return this.ignoreCase();
        }

        @Deprecated
        public PayloadTrieBuilder<T> removeOverlaps() {
            return this.ignoreOverlaps();
        }
    }
}

