/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.Optimize;
import io.jenetics.engine.EvolutionResult;
import io.jenetics.stat.DoubleMoments;
import java.util.function.Predicate;

final class SteadyPopulationLimit<N extends Number>
implements Predicate<EvolutionResult<?, N>> {
    private final int _generations;
    private int _stableGenerations = 0;
    private N _fitness;

    private SteadyPopulationLimit(int generations) {
        this._generations = generations;
    }

    @Override
    public boolean test(EvolutionResult<?, N> result) {
        DoubleMoments moments = result.getPopulation().stream().collect(DoubleMoments.toDoubleMoments(pt -> ((Number)pt.getFitness()).doubleValue()));
        boolean proceed = true;
        if (this._fitness == null) {
            this._fitness = (Number)result.getBestFitness();
            this._stableGenerations = 1;
        } else {
            Optimize opt = result.getOptimize();
            if (opt.compare((Comparable)this._fitness, result.getBestFitness()) >= 0) {
                proceed = ++this._stableGenerations <= this._generations;
            } else {
                this._fitness = (Number)result.getBestFitness();
                this._stableGenerations = 1;
            }
        }
        return proceed;
    }
}

