/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser.postscript;

import java.util.Map;
import java.util.Stack;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObject;
import org.verapdf.parser.postscript.PSObject;
import org.verapdf.parser.postscript.PSOperator;
import org.verapdf.parser.postscript.PostScriptException;

public class PSProcedure
extends PSObject {
    private final COSArray procedure;

    public PSProcedure(COSArray procedure) {
        super(procedure);
        this.procedure = procedure;
    }

    public void executeProcedure(Stack<COSObject> operandStack, Map<ASAtom, COSObject> userDict) throws PostScriptException {
        for (COSObject obj : this.procedure) {
            PSObject.getPSObject(obj).execute(operandStack, userDict);
        }
    }

    @Override
    public void execute(Stack<COSObject> operandStack, Map<ASAtom, COSObject> userDict) {
        operandStack.push(this);
    }

    public Stack<COSObject> modifiedExecuteProcedure(Stack<COSObject> operandStack, Map<ASAtom, COSObject> userDict) throws PostScriptException {
        for (COSObject obj : this.procedure) {
            if (obj == null) continue;
            if (obj instanceof PSOperator) {
                ((PSOperator)obj).execute(operandStack, userDict);
                continue;
            }
            operandStack.push(obj);
        }
        return operandStack;
    }
}

