/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.encryption;

public class AccessPermissions {
    private static final int DEFAULT_PERMISSIONS = -1;
    private static final int PRINT_BIT = 3;
    private static final int MODIFY_BIT = 4;
    private static final int EXTRACT_BIT = 5;
    private static final int MODIFY_ANNOTATIONS_BIT = 6;
    private static final int FILL_IN_BIT = 9;
    private static final int EXTRACT_FOR_ACCESSIBILITY_BIT = 10;
    private static final int ASSEMBLE_DOCUMENT_BIT = 11;
    private static final int DEGRADED_PRINT_BIT = 12;
    private final int bits;

    private AccessPermissions(int bits) {
        this.bits = bits;
    }

    public static AccessPermissions getOwnerPermissions() {
        return new AccessPermissions(-1);
    }

    public static AccessPermissions getUserPermissions(int p) {
        return new AccessPermissions(p);
    }

    private boolean isPermissionBitOn(int bit) {
        return (this.bits & 1 << bit - 1) != 0;
    }

    public boolean canPrint() {
        return this.isPermissionBitOn(3);
    }

    public boolean canModify() {
        return this.isPermissionBitOn(4);
    }

    public boolean canExtractContent() {
        return this.isPermissionBitOn(5);
    }

    public boolean canModifyAnnotations() {
        return this.isPermissionBitOn(6);
    }

    public boolean canFillInForm() {
        return this.isPermissionBitOn(9);
    }

    public boolean canExtractForAccessibility() {
        return this.isPermissionBitOn(10);
    }

    public boolean canAssembleDocument() {
        return this.isPermissionBitOn(11);
    }

    public boolean canPrintDegraded() {
        return this.isPermissionBitOn(12);
    }
}

