"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTooltipCompareFn = exports.getLegendCompareFn = exports.getRenderingCompareFn = exports.DEFAULT_SORTING_FN = void 0;
var DEFAULT_SORTING_FN = function () {
    return 0;
};
exports.DEFAULT_SORTING_FN = DEFAULT_SORTING_FN;
function getRenderingCompareFn(sortSeriesBy, defaultSortFn) {
    return getCompareFn('rendering', sortSeriesBy, defaultSortFn);
}
exports.getRenderingCompareFn = getRenderingCompareFn;
function getLegendCompareFn(sortSeriesBy, defaultSortFn) {
    return getCompareFn('legend', sortSeriesBy, defaultSortFn);
}
exports.getLegendCompareFn = getLegendCompareFn;
function getTooltipCompareFn(sortSeriesBy, defaultSortFn) {
    return getCompareFn('tooltip', sortSeriesBy, defaultSortFn);
}
exports.getTooltipCompareFn = getTooltipCompareFn;
function getCompareFn(aspect, sortSeriesBy, defaultSortFn) {
    var _a, _b;
    if (defaultSortFn === void 0) { defaultSortFn = exports.DEFAULT_SORTING_FN; }
    if (typeof sortSeriesBy === 'object') {
        return (_b = (_a = sortSeriesBy[aspect]) !== null && _a !== void 0 ? _a : sortSeriesBy.default) !== null && _b !== void 0 ? _b : defaultSortFn;
    }
    return sortSeriesBy !== null && sortSeriesBy !== void 0 ? sortSeriesBy : defaultSortFn;
}
//# sourceMappingURL=series_sort.js.map