/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class RFC1123DateConverter {
    private static final String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";

    public String format(Date date) {
        return this.getFormat().format(date);
    }

    public Date parse(String date) {
        try {
            return this.getFormat().parse(date);
        }
        catch (ParseException e) {
            String msg = String.format("The value \"%s\" is not a valid RFC 1123 date.", date);
            throw new IllegalArgumentException(msg, e);
        }
    }

    private DateFormat getFormat() {
        SimpleDateFormat rfc1123Format = new SimpleDateFormat(RFC1123_PATTERN, Locale.US);
        rfc1123Format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return rfc1123Format;
    }
}

