/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.analysis.Analyzer;
import org.opensearch.client.opensearch._types.analysis.AnalyzerVariant;
import org.opensearch.client.opensearch._types.analysis.NoriDecompoundMode;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NoriAnalyzer
implements AnalyzerVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, NoriAnalyzer> {
    @Nullable
    private final NoriDecompoundMode decompoundMode;
    @Nonnull
    private final List<String> stoptags;
    @Nullable
    private final String userDictionary;
    @Nullable
    private final String version;
    public static final JsonpDeserializer<NoriAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NoriAnalyzer::setupNoriAnalyzerDeserializer);

    private NoriAnalyzer(Builder builder) {
        this.decompoundMode = builder.decompoundMode;
        this.stoptags = ApiTypeHelper.unmodifiable(builder.stoptags);
        this.userDictionary = builder.userDictionary;
        this.version = builder.version;
    }

    public static NoriAnalyzer of(Function<Builder, ObjectBuilder<NoriAnalyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Analyzer.Kind _analyzerKind() {
        return Analyzer.Kind.Nori;
    }

    @Nullable
    public final NoriDecompoundMode decompoundMode() {
        return this.decompoundMode;
    }

    @Nonnull
    public final List<String> stoptags() {
        return this.stoptags;
    }

    @Nullable
    public final String userDictionary() {
        return this.userDictionary;
    }

    @Nullable
    public final String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "nori");
        if (this.decompoundMode != null) {
            generator.writeKey("decompound_mode");
            this.decompoundMode.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.stoptags)) {
            generator.writeKey("stoptags");
            generator.writeStartArray();
            for (String item0 : this.stoptags) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.userDictionary != null) {
            generator.writeKey("user_dictionary");
            generator.write(this.userDictionary);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNoriAnalyzerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::decompoundMode, NoriDecompoundMode._DESERIALIZER, "decompound_mode");
        op.add(Builder::stoptags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stoptags");
        op.add(Builder::userDictionary, JsonpDeserializer.stringDeserializer(), "user_dictionary");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.ignore("type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.decompoundMode);
        result = 31 * result + Objects.hashCode(this.stoptags);
        result = 31 * result + Objects.hashCode(this.userDictionary);
        result = 31 * result + Objects.hashCode(this.version);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoriAnalyzer other = (NoriAnalyzer)o;
        return Objects.equals(this.decompoundMode, other.decompoundMode) && Objects.equals(this.stoptags, other.stoptags) && Objects.equals(this.userDictionary, other.userDictionary) && Objects.equals(this.version, other.version);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, NoriAnalyzer> {
        @Nullable
        private NoriDecompoundMode decompoundMode;
        @Nullable
        private List<String> stoptags;
        @Nullable
        private String userDictionary;
        @Nullable
        private String version;

        public Builder() {
        }

        private Builder(NoriAnalyzer o) {
            this.decompoundMode = o.decompoundMode;
            this.stoptags = Builder._listCopy(o.stoptags);
            this.userDictionary = o.userDictionary;
            this.version = o.version;
        }

        private Builder(Builder o) {
            this.decompoundMode = o.decompoundMode;
            this.stoptags = Builder._listCopy(o.stoptags);
            this.userDictionary = o.userDictionary;
            this.version = o.version;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder decompoundMode(@Nullable NoriDecompoundMode value) {
            this.decompoundMode = value;
            return this;
        }

        @Nonnull
        public final Builder stoptags(List<String> list) {
            this.stoptags = Builder._listAddAll(this.stoptags, list);
            return this;
        }

        @Nonnull
        public final Builder stoptags(String value, String ... values) {
            this.stoptags = Builder._listAdd(this.stoptags, value, values);
            return this;
        }

        @Nonnull
        public final Builder userDictionary(@Nullable String value) {
            this.userDictionary = value;
            return this;
        }

        @Nonnull
        public final Builder version(@Nullable String value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        public NoriAnalyzer build() {
            this._checkSingleUse();
            return new NoriAnalyzer(this);
        }
    }
}

