/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.iotdb.ui.views;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.ext.generic.views.GenericConnectionPage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class IoTDBConnectionPage
extends GenericConnectionPage {
    private Combo sqlDialectCombo;
    private static final String GROUP_SQL_DIALECT = "sqlDialect";
    private boolean activated;

    public void createAdvancedSettingsGroup(Composite composite) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.saveAndUpdate();
            }
        };
        Composite additionalSettingsGroup = UIUtils.createTitledComposite((Composite)composite, (String)"Additional Settings", (int)4, (int)768);
        additionalSettingsGroup.setLayout((Layout)new GridLayout(4, false));
        this.sqlDialectCombo = UIUtils.createLabelCombo((Composite)additionalSettingsGroup, (String)"Sql Dialect", (int)12);
        this.sqlDialectCombo.addModifyListener(textListener);
        Control emptyLabel = UIUtils.createEmptyLabel((Composite)additionalSettingsGroup, (int)2, (int)1);
        this.addControlToGroup(GROUP_SQL_DIALECT, new Control[]{this.sqlDialectCombo});
        this.addControlToGroup(GROUP_SQL_DIALECT, new Control[]{emptyLabel});
    }

    private void saveAndUpdate() {
        this.saveSettings(this.site.getActiveDataSource());
        this.site.updateButtons();
    }

    public void loadSettings() {
        super.loadSettings();
        DBPDataSourceContainer dataSource = this.site.getActiveDataSource();
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.sqlDialectCombo != null) {
            this.sqlDialectCombo.removeAll();
            this.sqlDialectCombo.add("tree");
            this.sqlDialectCombo.add("table");
            if (this.site.isNew() && CommonUtils.isEmpty((String)connectionInfo.getServerName())) {
                this.sqlDialectCombo.setText(CommonUtils.notEmpty((String)this.site.getDriver().getDefaultServer()));
            } else {
                this.sqlDialectCombo.setText(CommonUtils.notEmpty((String)connectionInfo.getServerName()));
            }
        }
        this.activated = true;
        UIUtils.asyncExec(() -> {
            if (this.sqlDialectCombo != null && this.sqlDialectCombo.isVisible()) {
                this.sqlDialectCombo.setFocus();
            }
        });
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.sqlDialectCombo != null) {
            connectionInfo.setServerName(this.sqlDialectCombo.getText().trim());
        }
        super.saveSettings(dataSource);
    }
}

