/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph;

import docking.action.DockingAction;
import docking.action.DockingActionIf;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.functiongraph.FGColorProvider;
import ghidra.app.plugin.core.functiongraph.FGProvider;
import ghidra.app.plugin.core.functiongraph.FunctionGraphPlugin;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayoutProvider;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FgEnv;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphOptions;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import java.util.List;
import java.util.Objects;

public class DefaultFgEnv
implements FgEnv {
    private FGProvider provider;
    private FunctionGraphPlugin plugin;

    public DefaultFgEnv(FGProvider provider, FunctionGraphPlugin plugin) {
        this.provider = Objects.requireNonNull(provider);
        this.plugin = Objects.requireNonNull(plugin);
    }

    @Override
    public PluginTool getTool() {
        return this.plugin.getTool();
    }

    @Override
    public Program getProgram() {
        return this.provider.getProgram();
    }

    @Override
    public FunctionGraphOptions getOptions() {
        return this.plugin.getFunctionGraphOptions();
    }

    @Override
    public FGColorProvider getColorProvider() {
        return this.plugin.getColorProvider();
    }

    @Override
    public List<FGLayoutProvider> getLayoutProviders() {
        return this.plugin.getLayoutProviders();
    }

    @Override
    public void addLocalAction(DockingAction action) {
        this.provider.addLocalAction((DockingActionIf)action);
    }

    @Override
    public FormatManager getUserDefinedFormat() {
        return this.plugin.getUserDefinedFormat();
    }

    @Override
    public void setUserDefinedFormat(FormatManager format) {
        this.plugin.setUserDefinedFormat(format);
    }

    @Override
    public Navigatable getNavigatable() {
        return this.provider;
    }

    @Override
    public ProgramLocation getToolLocation() {
        return this.plugin.getProgramLocation();
    }

    @Override
    public void setSelection(ProgramSelection selection) {
        if (this.provider.isConnected()) {
            this.provider.setSelection(selection);
        } else {
            FGController controller = this.provider.getController();
            controller.setSelection(selection);
        }
    }

    @Override
    public ProgramLocation getGraphLocation() {
        return this.provider.getLocation();
    }
}

