/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import javax.swing.table.AbstractTableModel;
import org.jsampler.CC;
import org.jsampler.MidiDeviceModel;
import org.jsampler.event.MidiDeviceEvent;
import org.jsampler.event.MidiDeviceListEvent;
import org.jsampler.event.MidiDeviceListListener;
import org.jsampler.event.MidiDeviceListener;
import org.jsampler.view.classic.ClassicI18n;
import org.linuxsampler.lscp.MidiInputDevice;

class MidiDevicesTableModel
extends AbstractTableModel {
    protected static final int ACTIVE_COLUMN_INDEX = 0;
    protected static final int DEVICE_ID_COLUMN_INDEX = 1;
    protected static final int PORTS_COLUMN_INDEX = 2;
    private final String[] columnNames = new String[]{"", ClassicI18n.i18n.getLabel("MidiDevicesTableModel.deviceID"), ClassicI18n.i18n.getLabel("MidiDevicesTableModel.ports")};
    private MidiDeviceModel[] deviceList;
    private final Handler handler = new Handler();

    MidiDevicesTableModel() {
        CC.getSamplerModel().addMidiDeviceListListener(this.getHandler());
        for (MidiDeviceModel midiDeviceModel : this.deviceList = CC.getSamplerModel().getMidiDevices()) {
            midiDeviceModel.addMidiDeviceListener(this.getHandler());
        }
    }

    public MidiDeviceModel getMidiDeviceModel(int n) {
        return this.deviceList[n];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.deviceList.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.deviceList[n].getDeviceInfo().isActive();
            }
            case 1: {
                return this.deviceList[n].getDeviceId();
            }
            case 2: {
                return this.deviceList[n].getDeviceInfo().getMidiPortCount();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                boolean bl = (Boolean)object;
                this.deviceList[n].getDeviceInfo().setActive(bl);
                this.deviceList[n].setBackendActive(bl);
                break;
            }
            case 2: {
                int n3 = (Integer)object;
                this.getMidiDeviceModel(n).setBackendPortCount(n3);
                break;
            }
            default: {
                return;
            }
        }
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    private Handler getHandler() {
        return this.handler;
    }

    static /* synthetic */ MidiDeviceModel[] access$102(MidiDevicesTableModel midiDevicesTableModel, MidiDeviceModel[] midiDeviceModelArray) {
        midiDevicesTableModel.deviceList = midiDeviceModelArray;
        return midiDeviceModelArray;
    }

    private class Handler
    implements MidiDeviceListener,
    MidiDeviceListListener {
        private Handler() {
        }

        @Override
        public void deviceAdded(MidiDeviceListEvent midiDeviceListEvent) {
            for (MidiDeviceModel midiDeviceModel : MidiDevicesTableModel.this.deviceList) {
                midiDeviceModel.removeMidiDeviceListener(this);
            }
            MidiDevicesTableModel.access$102(MidiDevicesTableModel.this, CC.getSamplerModel().getMidiDevices());
            for (MidiDeviceModel midiDeviceModel : MidiDevicesTableModel.this.deviceList) {
                midiDeviceModel.addMidiDeviceListener(this);
            }
            MidiDevicesTableModel.this.fireTableDataChanged();
        }

        @Override
        public void deviceRemoved(MidiDeviceListEvent midiDeviceListEvent) {
            for (MidiDeviceModel midiDeviceModel : MidiDevicesTableModel.this.deviceList) {
                midiDeviceModel.removeMidiDeviceListener(this);
            }
            MidiDevicesTableModel.access$102(MidiDevicesTableModel.this, CC.getSamplerModel().getMidiDevices());
            for (MidiDeviceModel midiDeviceModel : MidiDevicesTableModel.this.deviceList) {
                midiDeviceModel.addMidiDeviceListener(this);
            }
            MidiDevicesTableModel.this.fireTableDataChanged();
        }

        @Override
        public void settingsChanged(MidiDeviceEvent midiDeviceEvent) {
            MidiInputDevice midiInputDevice = midiDeviceEvent.getMidiDeviceModel().getDeviceInfo();
            for (int i = 0; i < MidiDevicesTableModel.this.deviceList.length; ++i) {
                MidiInputDevice midiInputDevice2 = MidiDevicesTableModel.this.deviceList[i].getDeviceInfo();
                if (midiInputDevice.getDeviceId() != midiInputDevice2.getDeviceId()) continue;
                MidiDevicesTableModel.this.fireTableRowsUpdated(i, i);
            }
        }
    }
}

